/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.paginator;

import java.io.IOException;
import java.util.regex.Pattern;
import javax.faces.component.UINamingContainer;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.api.Pageable;
import org.primefaces.component.paginator.PaginatorElementRenderer;

public class RowsPerPageDropdownRenderer
implements PaginatorElementRenderer {
    private static final Pattern PATTERN = Pattern.compile("[,]+");

    @Override
    public void render(FacesContext context, Pageable pageable) throws IOException {
        String template = pageable.getRowsPerPageTemplate();
        UIViewRoot viewroot = context.getViewRoot();
        char separator = UINamingContainer.getSeparatorChar((FacesContext)context);
        if (template != null) {
            ResponseWriter writer = context.getResponseWriter();
            int actualRows = pageable.getRows();
            String[] options = PATTERN.split(pageable.getRowsPerPageTemplate());
            String clientId = pageable.getClientId(context);
            String ddId = clientId + separator + viewroot.createUniqueId();
            String ddName = clientId + "_rppDD";
            String labelId = null;
            labelId = ddId + "_rppLabel";
            writer.startElement("label", null);
            writer.writeAttribute("id", (Object)labelId, null);
            writer.writeAttribute("for", (Object)ddId, null);
            writer.writeAttribute("class", (Object)"ui-paginator-rpp-label ui-helper-hidden", null);
            writer.endElement("label");
            writer.startElement("select", null);
            writer.writeAttribute("id", (Object)ddId, null);
            writer.writeAttribute("name", (Object)ddName, null);
            writer.writeAttribute("aria-labelledby", (Object)labelId, null);
            writer.writeAttribute("class", (Object)"ui-paginator-rpp-options ui-widget ui-state-default", null);
            writer.writeAttribute("autocomplete", (Object)"off", null);
            for (String option : options) {
                int rows;
                String optionText;
                writer.startElement("option", null);
                if (option.trim().startsWith("{ShowAll|")) {
                    optionText = option.substring(option.indexOf(39) + 1, option.lastIndexOf(39));
                    rows = pageable.getRowCount();
                    writer.writeAttribute("value", (Object)"*", null);
                } else {
                    optionText = option.trim();
                    rows = Integer.parseInt(optionText);
                    writer.writeAttribute("value", (Object)rows, null);
                }
                if (actualRows == rows) {
                    writer.writeAttribute("selected", (Object)"selected", null);
                }
                writer.writeText((Object)optionText, null);
                writer.endElement("option");
            }
            writer.endElement("select");
        }
    }
}

