/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.picklist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AjaxBehaviorEvent;
import javax.faces.event.BehaviorEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.picklist.PickListBase;
import org.primefaces.event.AbstractAjaxBehaviorEvent;
import org.primefaces.event.SelectEvent;
import org.primefaces.event.TransferEvent;
import org.primefaces.event.UnselectEvent;
import org.primefaces.model.DualListModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.MapBuilder;
import org.primefaces.util.MessageFactory;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class PickList
extends PickListBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.PickList";
    public static final String CONTAINER_CLASS = "ui-picklist ui-widget ui-helper-clearfix";
    public static final String LIST_CLASS = "ui-widget-content ui-picklist-list";
    public static final String LIST_WRAPPER_CLASS = "ui-picklist-list-wrapper";
    public static final String SOURCE_CLASS = "ui-widget-content ui-picklist-list ui-picklist-source";
    public static final String TARGET_CLASS = "ui-widget-content ui-picklist-list ui-picklist-target";
    public static final String BUTTONS_CLASS = "ui-picklist-buttons";
    public static final String BUTTONS_CELL_CLASS = "ui-picklist-buttons-cell";
    public static final String SOURCE_CONTROLS = "ui-picklist-source-controls ui-picklist-buttons";
    public static final String TARGET_CONTROLS = "ui-picklist-target-controls ui-picklist-buttons";
    public static final String ITEM_CLASS = "ui-picklist-item";
    public static final String ITEM_DISABLED_CLASS = "ui-state-disabled";
    public static final String CAPTION_CLASS = "ui-picklist-caption ui-widget-header";
    public static final String ADD_BUTTON_CLASS = "ui-picklist-button-add";
    public static final String ADD_ALL_BUTTON_CLASS = "ui-picklist-button-add-all";
    public static final String REMOVE_BUTTON_CLASS = "ui-picklist-button-remove";
    public static final String REMOVE_ALL_BUTTON_CLASS = "ui-picklist-button-remove-all";
    public static final String ADD_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrow-1-e";
    public static final String ADD_ALL_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrowstop-1-e";
    public static final String REMOVE_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrow-1-w";
    public static final String REMOVE_ALL_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrowstop-1-w";
    public static final String VERTICAL_ADD_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrow-1-s";
    public static final String VERTICAL_ADD_ALL_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrowstop-1-s";
    public static final String VERTICAL_REMOVE_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrow-1-n";
    public static final String VERTICAL_REMOVE_ALL_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrowstop-1-n";
    public static final String MOVE_UP_BUTTON_CLASS = "ui-picklist-button-move-up";
    public static final String MOVE_DOWN_BUTTON_CLASS = "ui-picklist-button-move-down";
    public static final String MOVE_TOP_BUTTON_CLASS = "ui-picklist-button-move-top";
    public static final String MOVE_BOTTOM_BUTTON_CLASS = "ui-picklist-button-move-bottom";
    public static final String MOVE_UP_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrow-1-n";
    public static final String MOVE_DOWN_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrow-1-s";
    public static final String MOVE_TOP_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrowstop-1-n";
    public static final String MOVE_BOTTOM_BUTTON_ICON_CLASS = "ui-icon ui-icon-arrowstop-1-s";
    public static final String FILTER_CLASS = "ui-picklist-filter ui-inputfield ui-inputtext ui-widget ui-state-default";
    public static final String FILTER_CONTAINER = "ui-picklist-filter-container";
    private static final Map<String, Class<? extends BehaviorEvent>> BEHAVIOR_EVENT_MAPPING = MapBuilder.builder().put("transfer", TransferEvent.class).put("select", SelectEvent.class).put("unselect", UnselectEvent.class).put("reorder", null).build();
    private static final Collection<String> EVENT_NAMES = BEHAVIOR_EVENT_MAPPING.keySet();
    private Map<String, AjaxBehaviorEvent> customEvents = new HashMap<String, AjaxBehaviorEvent>(1);

    @Override
    public Map<String, Class<? extends BehaviorEvent>> getBehaviorEventMapping() {
        return BEHAVIOR_EVENT_MAPPING;
    }

    public Collection<String> getEventNames() {
        return EVENT_NAMES;
    }

    public String getDefaultEventName() {
        return "transfer";
    }

    protected void validateValue(FacesContext facesContext, Object newValue) {
        super.validateValue(facesContext, newValue);
        DualListModel newModel = (DualListModel)newValue;
        DualListModel oldModel = (DualListModel)this.getValue();
        String clientId = this.getClientId(facesContext);
        String label = this.getLabel();
        if (label == null) {
            label = clientId;
        }
        if (this.isRequired() && newModel.getTarget().isEmpty()) {
            String requiredMessage = this.getRequiredMessage();
            FacesMessage message = null;
            message = requiredMessage != null ? new FacesMessage(FacesMessage.SEVERITY_ERROR, requiredMessage, requiredMessage) : MessageFactory.getFacesMessage(facesContext, "javax.faces.component.UIInput.REQUIRED", FacesMessage.SEVERITY_ERROR, label);
            facesContext.addMessage(clientId, message);
            this.setValid(false);
        }
        if (this.isValid()) {
            List oldModelSource = oldModel == null ? Collections.emptyList() : oldModel.getSource();
            List oldModelTarget = oldModel == null ? Collections.emptyList() : oldModel.getTarget();
            this.validateTarget(facesContext, label, newModel.getTarget(), oldModelSource, oldModelTarget);
            this.validateDisabled(facesContext, label, newModel.getSource(), oldModelSource);
            this.validateDisabled(facesContext, label, newModel.getTarget(), oldModelTarget);
        }
    }

    private void validateTarget(FacesContext facesContext, String label, List<?> targetEntries, List<?> oldSource, List<?> oldTarget) {
        String clientId = this.getClientId(facesContext);
        for (int i = 0; i < targetEntries.size(); ++i) {
            Object targetItem = targetEntries.get(i);
            if (oldSource.contains(targetItem) || oldTarget.contains(targetItem)) continue;
            FacesMessage message = MessageFactory.getFacesMessage(facesContext, "javax.faces.component.UIInput.UPDATE", FacesMessage.SEVERITY_ERROR, label);
            facesContext.addMessage(clientId, message);
            this.setValid(false);
            break;
        }
    }

    protected void validateDisabled(FacesContext facesContext, String label, List<?> newEntries, List<?> oldEntries) {
        if (!this.isValid()) {
            return;
        }
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        String varName = this.getVar();
        String clientId = this.getClientId(facesContext);
        Object originalItem = requestMap.get(varName);
        for (int i = 0; i < newEntries.size(); ++i) {
            Object item = newEntries.get(i);
            requestMap.put(varName, item);
            boolean itemDisabled = this.isItemDisabled();
            if (!itemDisabled || oldEntries.contains(item)) continue;
            FacesMessage message = MessageFactory.getFacesMessage(facesContext, "javax.faces.component.UIInput.UPDATE", FacesMessage.SEVERITY_ERROR, label);
            facesContext.addMessage(clientId, message);
            this.setValid(false);
            break;
        }
        requestMap.put(varName, originalItem);
    }

    public void validate(FacesContext context) {
        super.validate(context);
        if (this.isValid() && this.customEvents != null) {
            for (Map.Entry<String, AjaxBehaviorEvent> event : this.customEvents.entrySet()) {
                int itemIndex;
                String listName;
                String eventName = event.getKey();
                SelectEvent behaviorEvent = event.getValue();
                Map params = context.getExternalContext().getRequestParameterMap();
                String clientId = this.getClientId(context);
                DualListModel list = (DualListModel)this.getValue();
                AbstractAjaxBehaviorEvent wrapperEvent = null;
                if ("select".equals(eventName)) {
                    listName = (String)params.get(clientId + "_listName");
                    itemIndex = Integer.parseInt((String)params.get(clientId + "_itemIndex"));
                    wrapperEvent = "target".equals(listName) ? new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), list.getTarget().get(itemIndex)) : new SelectEvent((UIComponent)this, behaviorEvent.getBehavior(), list.getSource().get(itemIndex));
                } else if ("unselect".equals(eventName)) {
                    listName = (String)params.get(clientId + "_listName");
                    itemIndex = Integer.parseInt((String)params.get(clientId + "_itemIndex"));
                    wrapperEvent = "target".equals(listName) ? new UnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), list.getTarget().get(itemIndex)) : new UnselectEvent((UIComponent)this, behaviorEvent.getBehavior(), list.getSource().get(itemIndex));
                } else if ("reorder".equals(eventName)) {
                    wrapperEvent = behaviorEvent;
                }
                if (wrapperEvent == null) {
                    throw new FacesException("Component " + this.getClass().getName() + " does not support event " + eventName + "!");
                }
                wrapperEvent.setPhaseId(behaviorEvent.getPhaseId());
                super.queueEvent((FacesEvent)wrapperEvent);
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        FacesContext context = this.getFacesContext();
        if (ComponentUtils.isRequestSource((UIComponent)this, context) && event instanceof AjaxBehaviorEvent) {
            Map paramValues = context.getExternalContext().getRequestParameterValuesMap();
            Map params = context.getExternalContext().getRequestParameterMap();
            String eventName = (String)params.get("javax.faces.behavior.event");
            String clientId = this.getClientId(context);
            AjaxBehaviorEvent behaviorEvent = (AjaxBehaviorEvent)event;
            if ("transfer".equals(eventName)) {
                String[] items = (String[])paramValues.get(clientId + "_transferred");
                boolean isAdd = Boolean.parseBoolean((String)params.get(clientId + "_add"));
                ArrayList transferredItems = new ArrayList();
                this.populateModel(context, items, transferredItems);
                TransferEvent transferEvent = new TransferEvent((UIComponent)this, behaviorEvent.getBehavior(), transferredItems, isAdd);
                transferEvent.setPhaseId(event.getPhaseId());
                super.queueEvent((FacesEvent)transferEvent);
            } else if ("select".equals(eventName) || "unselect".equals(eventName) || "reorder".equals(eventName)) {
                this.customEvents.put(eventName, (AjaxBehaviorEvent)event);
            }
        } else {
            super.queueEvent(event);
        }
    }

    public void populateModel(FacesContext context, String[] values, List model) {
        Converter converter = this.getConverter();
        if (values != null) {
            for (String item : values) {
                String convertedValue;
                if (LangUtils.isBlank(item)) continue;
                String string = convertedValue = converter != null ? converter.getAsObject(context, (UIComponent)this, item) : item;
                if (convertedValue == null) continue;
                model.add(convertedValue);
            }
        }
    }

    public Object saveState(FacesContext context) {
        if (this.customEvents != null) {
            this.customEvents.clear();
        }
        return super.saveState(context);
    }
}

