/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.radiobutton;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.radiobutton.RadioButton;
import org.primefaces.component.selectoneradio.SelectOneRadio;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.InputRenderer;
import org.primefaces.util.SharedStringBuilder;

public class RadioButtonRenderer
extends InputRenderer {
    private static final String SB_BUILD_EVENT = RadioButtonRenderer.class.getName() + "#buildEvent";

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        RadioButton radioButton = (RadioButton)component;
        SelectOneRadio selectOneRadio = (SelectOneRadio)SearchExpressionUtils.contextlessResolveComponent(context, (UIComponent)radioButton, radioButton.getFor());
        this.encodeMarkup(context, radioButton, selectOneRadio);
    }

    protected void encodeMarkup(FacesContext context, RadioButton radio, SelectOneRadio selectOneRadio) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String masterClientId = selectOneRadio.getClientId(context);
        String inputId = selectOneRadio.getRadioButtonId(context, radio.getItemIndex());
        String clientId = radio.getClientId(context);
        boolean disabled = radio.isDisabled() || selectOneRadio.isDisabled();
        String style = radio.getStyle();
        String styleClass = this.getStyleClassBuilder(context).add("ui-radiobutton ui-widget").add(radio.getStyleClass()).build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        this.encodeOptionInput(context, selectOneRadio, radio, inputId, masterClientId, disabled);
        this.encodeOptionOutput(context, disabled, selectOneRadio);
        writer.endElement("div");
    }

    protected void encodeOptionInput(FacesContext context, SelectOneRadio radio, RadioButton button, String id, String name, boolean disabled) throws IOException {
        String onclick;
        String onchange;
        ResponseWriter writer = context.getResponseWriter();
        String tabindex = button.getTabindex();
        if (tabindex == null) {
            tabindex = radio.getTabindex();
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-helper-hidden-accessible", null);
        writer.startElement("input", null);
        writer.writeAttribute("id", (Object)(id + "_clone"), null);
        writer.writeAttribute("name", (Object)(name + "_clone"), null);
        writer.writeAttribute("type", (Object)"radio", null);
        writer.writeAttribute("class", (Object)"ui-radio-clone", null);
        writer.writeAttribute("data-itemindex", (Object)button.getItemIndex(), null);
        this.renderAccessibilityAttributes(context, (UIInput)radio, disabled, radio.isReadonly());
        if (tabindex != null) {
            writer.writeAttribute("tabindex", (Object)tabindex, null);
        }
        if (!this.isValueBlank(onchange = this.buildEvent(context, radio, button, "onchange", "change", "valueChange"))) {
            writer.writeAttribute("onchange", (Object)onchange, null);
        }
        if (!this.isValueBlank(onclick = this.buildEvent(context, radio, button, "onclick", "click", "click"))) {
            writer.writeAttribute("onclick", (Object)onclick, null);
        }
        writer.endElement("input");
        writer.endElement("div");
    }

    protected String buildEvent(FacesContext context, SelectOneRadio radio, RadioButton button, String domEvent, String behaviorEvent, String behaviorEventAlias) {
        String radioEvent = this.buildDomEvent(context, (UIComponent)radio, domEvent, behaviorEvent, behaviorEventAlias, null);
        String buttonEvent = this.buildDomEvent(context, (UIComponent)button, domEvent, behaviorEvent, behaviorEventAlias, null);
        StringBuilder eventBuilder = SharedStringBuilder.get(context, SB_BUILD_EVENT);
        if (radioEvent != null) {
            eventBuilder.append(radioEvent);
        }
        if (buttonEvent != null) {
            eventBuilder.append(buttonEvent);
        }
        return eventBuilder.toString();
    }

    protected void encodeOptionOutput(FacesContext context, boolean disabled, SelectOneRadio selectOneRadio) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object boxClass = this.createStyleClass((UIInput)selectOneRadio, null, "ui-radiobutton-box ui-widget ui-state-default");
        boxClass = disabled ? (String)boxClass + " ui-state-disabled" : boxClass;
        writer.startElement("div", null);
        writer.writeAttribute("class", boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-radiobutton-icon ui-icon ui-icon-blank ui-c", null);
        writer.endElement("span");
        writer.endElement("div");
    }
}

