/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.rowtoggler;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.datatable.DataTable;
import org.primefaces.component.rowtoggler.RowToggler;
import org.primefaces.renderkit.CoreRenderer;

public class RowTogglerRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        RowToggler toggler = (RowToggler)component;
        DataTable parentTable = toggler.getParentTable(context);
        String rowKey = parentTable.getRowKey(parentTable.getRowData());
        boolean expanded = parentTable.isExpandedRow() || parentTable.getExpandedRowKeys().contains(rowKey);
        String expandIcon = toggler.getExpandIcon();
        String collapseIcon = toggler.getCollapseIcon();
        String icon = "ui-icon " + (expanded ? collapseIcon : expandIcon);
        String expandLabel = toggler.getExpandLabel();
        String collapseLabel = toggler.getCollapseLabel();
        boolean iconOnly = expandLabel == null && collapseLabel == null;
        Object togglerClass = iconOnly ? "ui-row-toggler " + icon : "ui-row-toggler";
        writer.startElement("div", (UIComponent)toggler);
        writer.writeAttribute("class", togglerClass, null);
        writer.writeAttribute("tabindex", (Object)toggler.getTabindex(), null);
        writer.writeAttribute("role", (Object)"button", null);
        writer.writeAttribute("data-expand-icon", (Object)expandIcon, null);
        writer.writeAttribute("data-collapse-icon", (Object)collapseIcon, null);
        writer.writeAttribute("aria-expanded", (Object)String.valueOf(expanded), null);
        if (!iconOnly) {
            this.writeLabel(writer, expandLabel, !expanded);
            this.writeLabel(writer, collapseLabel, expanded);
        }
        writer.endElement("div");
    }

    protected void writeLabel(ResponseWriter writer, String label, boolean visible) throws IOException {
        writer.startElement("span", null);
        if (!visible) {
            writer.writeAttribute("class", (Object)"ui-helper-hidden", null);
        }
        writer.writeText((Object)label, null);
        writer.endElement("span");
    }
}

