/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.sidebar;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.sidebar.Sidebar;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.WidgetBuilder;

public class SidebarRenderer
extends CoreRenderer {
    public void decode(FacesContext context, UIComponent component) {
        this.decodeBehaviors(context, component);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Sidebar sidebar = (Sidebar)component;
        if (sidebar.isContentLoadRequest(context)) {
            this.renderChildren(context, (UIComponent)sidebar);
        } else {
            this.encodeMarkup(context, sidebar);
            this.encodeScript(context, sidebar);
        }
    }

    protected void encodeMarkup(FacesContext context, Sidebar sidebar) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String style = sidebar.getStyle();
        Object styleClass = sidebar.getStyleClass();
        styleClass = styleClass == null ? "ui-sidebar ui-widget ui-widget-content ui-shadow" : "ui-sidebar ui-widget ui-widget-content ui-shadow " + (String)styleClass;
        styleClass = sidebar.isFullScreen() ? (String)styleClass + " ui-sidebar-full" : styleClass;
        styleClass = (String)styleClass + " ui-sidebar-" + sidebar.getPosition();
        writer.startElement("div", (UIComponent)sidebar);
        writer.writeAttribute("id", (Object)sidebar.getClientId(context), null);
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        if (sidebar.isShowCloseIcon()) {
            this.encodeCloseIcon(context);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-sidebar-content ui-widget-content", null);
        writer.writeAttribute("id", (Object)(sidebar.getClientId(context) + "_content"), null);
        if (!sidebar.isDynamic()) {
            this.renderChildren(context, (UIComponent)sidebar);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeCloseIcon(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("a", null);
        writer.writeAttribute("href", (Object)"#", null);
        writer.writeAttribute("class", (Object)"ui-sidebar-close", null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-closethick", null);
        writer.endElement("span");
        writer.endElement("a");
    }

    private void encodeScript(FacesContext context, Sidebar sidebar) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Sidebar", sidebar).attr("visible", sidebar.isVisible(), false).attr("modal", sidebar.isModal(), true).attr("blockScroll", sidebar.isBlockScroll(), false).attr("baseZIndex", sidebar.getBaseZIndex(), 0).attr("dynamic", sidebar.isDynamic(), false).attr("showCloseIcon", sidebar.isShowCloseIcon(), true).attr("appendTo", SearchExpressionUtils.resolveOptionalClientIdForClientSide(context, (UIComponent)sidebar, sidebar.getAppendTo())).callback("onHide", "function()", sidebar.getOnHide()).callback("onShow", "function()", sidebar.getOnShow());
        this.encodeClientBehaviors(context, sidebar);
        wb.finish();
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

