/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.skeleton;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.skeleton.Skeleton;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.LangUtils;

public class SkeletonRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        Skeleton skeleton = (Skeleton)component;
        ResponseWriter writer = context.getResponseWriter();
        String size = skeleton.getSize();
        String styleClass = this.getStyleClassBuilder(context).add("ui-skeleton ui-widget").add(skeleton.getStyleClass()).add("circle".equals(skeleton.getShape()), "ui-skeleton-circle").add("none".equals(skeleton.getAnimation()), "ui-skeleton-animation-none").build();
        String style = this.getStyleBuilder(context).add(skeleton.getStyle()).add(size != null, "width", size, skeleton.getWidth()).add(size != null, "height", size, skeleton.getHeight()).add("border-radius", skeleton.getBorderRadius()).build();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)skeleton.getClientId(context), "id");
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (LangUtils.isNotBlank(style)) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        writer.endElement("div");
    }
}

