/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.splitbutton;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.component.splitbutton.SplitButtonBase;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;

@ResourceDependencies(value={@ResourceDependency(library="primefaces", name="components.css"), @ResourceDependency(library="primefaces", name="jquery/jquery.js"), @ResourceDependency(library="primefaces", name="jquery/jquery-plugins.js"), @ResourceDependency(library="primefaces", name="core.js"), @ResourceDependency(library="primefaces", name="components.js")})
public class SplitButton
extends SplitButtonBase {
    public static final String COMPONENT_TYPE = "org.primefaces.component.SplitButton";
    public static final String STYLE_CLASS = "ui-splitbutton ui-buttonset ui-widget";
    public static final String BUTTON_TEXT_ICON_LEFT_BUTTON_CLASS = "ui-button ui-widget ui-state-default ui-button-text-icon-left";
    public static final String BUTTON_TEXT_ICON_RIGHT_BUTTON_CLASS = "ui-button ui-widget ui-state-default ui-button-text-icon-right";
    public static final String MENU_ICON_BUTTON_CLASS = "ui-splitbutton-menubutton ui-button ui-widget ui-state-default ui-button-icon-only";
    public static final String BUTTON_TEXT_ONLY_BUTTON_CLASS = "ui-button ui-widget ui-state-default ui-button-text-only";
    public static final String BUTTON_ICON_ONLY_BUTTON_CLASS = "ui-button ui-widget ui-state-default ui-button-icon-only";
    public static final String SPLITBUTTON_CONTAINER_CLASS = "ui-menu ui-splitbuttonmenu ui-menu-dynamic ui-widget ui-widget-content ui-helper-clearfix ui-shadow";
    public static final String LIST_WRAPPER_CLASS = "ui-splitbuttonmenu-list-wrapper";
    private String confirmationScript;

    public String resolveStyleClass() {
        boolean iconBlank = LangUtils.isBlank(this.getIcon());
        boolean valueBlank = this.getValue() == null;
        boolean modelBlank = this.getModel() == null;
        Object styleClass = "";
        if (modelBlank && !ComponentUtils.shouldRenderChildren((UIComponent)this)) {
            if (!valueBlank && iconBlank) {
                styleClass = BUTTON_TEXT_ONLY_BUTTON_CLASS;
            } else if (!valueBlank) {
                styleClass = this.getIconPos().equals("left") ? BUTTON_TEXT_ICON_LEFT_BUTTON_CLASS : BUTTON_TEXT_ICON_RIGHT_BUTTON_CLASS;
            } else if (!iconBlank) {
                styleClass = BUTTON_ICON_ONLY_BUTTON_CLASS;
            }
        } else if (!valueBlank && iconBlank) {
            styleClass = BUTTON_TEXT_ONLY_BUTTON_CLASS;
        } else if (!valueBlank) {
            styleClass = this.getIconPos().equals("left") ? BUTTON_TEXT_ICON_LEFT_BUTTON_CLASS : BUTTON_TEXT_ICON_RIGHT_BUTTON_CLASS;
        } else if (!iconBlank) {
            styleClass = BUTTON_ICON_ONLY_BUTTON_CLASS;
        }
        if (this.isDisabled()) {
            styleClass = (String)styleClass + " ui-state-disabled";
        }
        return styleClass;
    }

    public void processDecodes(FacesContext context) {
        if (!this.isRendered() || this.isDisabled()) {
            return;
        }
        super.processDecodes(context);
    }

    @Override
    public boolean isPartialSubmitSet() {
        return this.getStateHelper().get((Serializable)((Object)SplitButtonBase.PropertyKeys.partialSubmit)) != null || this.getValueExpression(SplitButtonBase.PropertyKeys.partialSubmit.toString()) != null;
    }

    @Override
    public boolean isResetValuesSet() {
        return this.getStateHelper().get((Serializable)((Object)SplitButtonBase.PropertyKeys.resetValues)) != null || this.getValueExpression(SplitButtonBase.PropertyKeys.resetValues.toString()) != null;
    }

    @Override
    public boolean isAjaxified() {
        return this.isAjax();
    }

    @Override
    public List<MenuElement> getElements() {
        MenuModel model = this.getModel();
        if (model != null) {
            return model.getElements();
        }
        return this.getChildren().stream().filter(MenuElement.class::isInstance).filter(UIComponent::isRendered).map(MenuElement.class::cast).collect(Collectors.toList());
    }

    public int getElementsCount() {
        List<MenuElement> elements = this.getElements();
        return elements == null ? 0 : elements.size();
    }

    public OverlayPanel getCustomOverlay() {
        return this.getChildren().stream().filter(OverlayPanel.class::isInstance).filter(UIComponent::isRendered).map(OverlayPanel.class::cast).findAny().orElse(null);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        this.broadcastMenuActionEvent(event, this.getFacesContext(), x$0 -> super.broadcast(x$0));
    }

    @Override
    public boolean requiresConfirmation() {
        return this.confirmationScript != null;
    }

    @Override
    public String getConfirmationScript() {
        return this.confirmationScript;
    }

    @Override
    public void setConfirmationScript(String confirmationScript) {
        this.confirmationScript = confirmationScript;
    }

    public String getDefaultEventName() {
        return "click";
    }
}

