/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.splitbutton;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.api.MenuItemAware;
import org.primefaces.component.overlaypanel.OverlayPanel;
import org.primefaces.component.splitbutton.SplitButton;
import org.primefaces.expression.SearchExpressionUtils;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.model.menu.MenuModel;
import org.primefaces.model.menu.Separator;
import org.primefaces.model.menu.Submenu;
import org.primefaces.renderkit.MenuItemAwareRenderer;
import org.primefaces.util.ComponentTraversalUtils;
import org.primefaces.util.HTML;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;
import org.primefaces.util.WidgetBuilder;

public class SplitButtonRenderer
extends MenuItemAwareRenderer {
    private static final String SB_BUILD_ONCLICK = SplitButtonRenderer.class.getName() + "#buildOnclick";

    @Override
    public void decode(FacesContext context, UIComponent component) {
        OverlayPanel customOverlay;
        SplitButton button = (SplitButton)component;
        if (button.isDisabled()) {
            return;
        }
        boolean menuItemDecoded = this.decodeDynamicMenuItem(context, component);
        if (!menuItemDecoded) {
            Object param;
            String clientId = button.getClientId(context);
            Map params = context.getExternalContext().getRequestParameterMap();
            Object object = param = button.isAjax() ? clientId : clientId + "_button";
            if (params.containsKey(param)) {
                component.queueEvent((FacesEvent)new ActionEvent(component));
            }
        }
        if ((customOverlay = button.getCustomOverlay()) != null) {
            customOverlay.getRenderer().decode(context, (UIComponent)customOverlay);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        SplitButton button = (SplitButton)component;
        MenuModel model = button.getModel();
        if (model != null && button.getElementsCount() > 0) {
            model.generateUniqueIds();
        }
        this.encodeMarkup(context, button);
        this.encodeScript(context, button);
    }

    protected void encodeMarkup(FacesContext context, SplitButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = button.getClientId(context);
        String menuId = clientId + "_menu";
        String menuButtonId = clientId + "_menuButton";
        String buttonId = clientId + "_button";
        Object styleClass = button.getStyleClass();
        styleClass = styleClass == null ? "ui-splitbutton ui-buttonset ui-widget" : "ui-splitbutton ui-buttonset ui-widget " + (String)styleClass;
        boolean hasOverlay = this.shouldBeRendered(context, button);
        writer.startElement("div", (UIComponent)button);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.writeAttribute("class", styleClass, "id");
        if (button.getStyle() != null) {
            writer.writeAttribute("style", (Object)button.getStyle(), "id");
        }
        this.encodeDefaultButton(context, button, buttonId);
        OverlayPanel customOverlay = button.getCustomOverlay();
        if (customOverlay != null || button.getElementsCount() > 0) {
            this.encodeMenuIcon(context, button, menuButtonId, menuId, hasOverlay);
            if (hasOverlay) {
                this.encodeMenu(context, button, menuId);
            }
        }
        writer.endElement("div");
        if (customOverlay != null) {
            customOverlay.setFor(clientId);
            customOverlay.getRenderer().encodeEnd(context, (UIComponent)customOverlay);
        }
    }

    protected void encodeDefaultButton(FacesContext context, SplitButton button, String id) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = button.getIcon();
        String onclick = this.buildOnclick(context, button);
        if (LangUtils.isNotEmpty(onclick) && button.requiresConfirmation()) {
            writer.writeAttribute("data-pfconfirmcommand", (Object)onclick, null);
        }
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)id, "id");
        writer.writeAttribute("name", (Object)id, "name");
        writer.writeAttribute("class", (Object)button.resolveStyleClass(), "styleClass");
        if (!onclick.isEmpty()) {
            if (button.requiresConfirmation()) {
                writer.writeAttribute("onclick", (Object)button.getConfirmationScript(), "onclick");
            } else {
                writer.writeAttribute("onclick", (Object)onclick, "onclick");
            }
        }
        ArrayList<String> attrs = new ArrayList<String>(HTML.BUTTON_WITHOUT_CLICK_ATTRS);
        attrs.remove("style");
        this.renderPassThruAttributes(context, (UIComponent)button, (List<String>)attrs);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        if (!this.isValueBlank(icon)) {
            String defaultIconClass = button.getIconPos().equals("left") ? "ui-button-icon-left ui-icon ui-c" : "ui-button-icon-right ui-icon ui-c";
            String iconClass = defaultIconClass + " " + icon;
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)iconClass, null);
            writer.endElement("span");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        this.renderButtonValue(writer, true, button.getValue(), button.getTitle(), button.getAriaLabel());
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeMenuIcon(FacesContext context, SplitButton button, String id, String menuId, boolean hasOverlay) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object buttonClass = "ui-splitbutton-menubutton ui-button ui-widget ui-state-default ui-button-icon-only";
        if (button.isDisabled()) {
            buttonClass = (String)buttonClass + " ui-state-disabled";
        }
        writer.startElement("button", (UIComponent)button);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"button", null);
        writer.writeAttribute("class", buttonClass, null);
        writer.writeAttribute("aria-haspopup", (Object)(hasOverlay ? "menu" : "false"), null);
        writer.writeAttribute("aria-controls", (Object)menuId, null);
        writer.writeAttribute("aria-expanded", (Object)"false", null);
        if (button.isDisabled()) {
            writer.writeAttribute("disabled", (Object)"disabled", "disabled");
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-icon-left ui-icon ui-c ui-icon-triangle-1-s", null);
        writer.endElement("span");
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-button-text ui-c", null);
        writer.writeText((Object)this.getIconOnlyButtonText(button.getTitle(), button.getAriaLabel()), null);
        writer.endElement("span");
        writer.endElement("button");
    }

    protected void encodeScript(FacesContext context, SplitButton button) throws IOException {
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("SplitButton", button).attr("appendTo", SearchExpressionUtils.resolveOptionalClientIdForClientSide(context, (UIComponent)button, button.getAppendTo()));
        if (button.isFilter()) {
            wb.attr("filter", true).attr("filterMatchMode", button.getFilterMatchMode(), null).nativeAttr("filterFunction", button.getFilterFunction(), null).attr("filterNormalize", button.isFilterNormalize(), false).attr("filterInputAutoFocus", button.isFilterInputAutoFocus(), true);
        }
        wb.attr("disableOnAjax", button.isDisableOnAjax(), true).attr("disabledAttr", button.isDisabled(), false).finish();
    }

    protected String buildOnclick(FacesContext context, SplitButton button) throws IOException {
        StringBuilder onclick = SharedStringBuilder.get(context, SB_BUILD_ONCLICK);
        if (button.getOnclick() != null) {
            onclick.append(button.getOnclick()).append(";");
        }
        if (button.isAjax()) {
            onclick.append(this.buildAjaxRequest(context, button));
        } else {
            UIForm form = ComponentTraversalUtils.closestForm((UIComponent)button);
            if (form == null) {
                throw new FacesException("SplitButton : \"" + button.getClientId(context) + "\" must be inside a form element");
            }
            onclick.append(this.buildNonAjaxRequest(context, (UIComponent)button, (UIComponent)form, null, false));
        }
        String onclickBehaviors = this.getEventBehaviors(context, (ClientBehaviorHolder)button, "click", null);
        if (onclickBehaviors != null) {
            onclick.append(onclickBehaviors).append(";");
        }
        return onclick.toString();
    }

    protected void encodeMenu(FacesContext context, SplitButton button, String menuId) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Object menuStyleClass = button.getMenuStyleClass();
        menuStyleClass = menuStyleClass == null ? "ui-menu ui-splitbuttonmenu ui-menu-dynamic ui-widget ui-widget-content ui-helper-clearfix ui-shadow" : "ui-menu ui-splitbuttonmenu ui-menu-dynamic ui-widget ui-widget-content ui-helper-clearfix ui-shadow " + (String)menuStyleClass;
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)menuId, null);
        writer.writeAttribute("class", menuStyleClass, "styleClass");
        writer.writeAttribute("aria-labelledby", (Object)button.getClientId(context), null);
        writer.writeAttribute("tabindex", (Object)"-1", null);
        if (button.isFilter()) {
            this.encodeFilter(context, button);
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-splitbuttonmenu-list-wrapper", "styleClass");
        writer.startElement("ul", null);
        writer.writeAttribute("class", (Object)"ui-menu-list ui-helper-reset", "styleClass");
        writer.writeAttribute("role", (Object)"menu", null);
        this.encodeElements(context, button, button.getElements(), false);
        writer.endElement("ul");
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeElements(FacesContext context, SplitButton button, List<MenuElement> elements, boolean isSubmenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        for (MenuElement element : elements) {
            if (element instanceof MenuItem) {
                MenuItem menuItem = (MenuItem)element;
                if (!menuItem.isRendered()) continue;
                String containerStyle = menuItem.getContainerStyle();
                Object containerStyleClass = menuItem.getContainerStyleClass();
                Object object = containerStyleClass = containerStyleClass == null ? "ui-menuitem ui-widget" : "ui-menuitem ui-widget " + (String)containerStyleClass;
                if (isSubmenu) {
                    containerStyleClass = (String)containerStyleClass + " ui-submenu-child";
                }
                writer.startElement("li", null);
                writer.writeAttribute("class", containerStyleClass, null);
                writer.writeAttribute("role", (Object)"none", null);
                if (containerStyle != null) {
                    writer.writeAttribute("style", (Object)containerStyle, null);
                }
                this.encodeMenuItem(context, button, menuItem);
                writer.endElement("li");
                continue;
            }
            if (element instanceof Submenu) {
                this.encodeSubmenu(context, button, (Submenu)element);
                continue;
            }
            if (!(element instanceof Separator)) continue;
            this.encodeSeparator(context, (Separator)element);
        }
    }

    protected void encodeMenuItem(FacesContext context, SplitButton button, MenuItem menuitem) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String icon = menuitem.getIcon();
        String title = menuitem.getTitle();
        if (menuitem.shouldRenderChildren()) {
            this.renderChildren(context, (UIComponent)menuitem);
        } else {
            Object styleClass;
            boolean disabled = menuitem.isDisabled();
            writer.startElement("a", null);
            writer.writeAttribute("id", (Object)menuitem.getClientId(), null);
            writer.writeAttribute("tabindex", (Object)"-1", null);
            writer.writeAttribute("role", (Object)"menuitem", null);
            if (title != null) {
                writer.writeAttribute("title", (Object)title, null);
            }
            styleClass = (styleClass = menuitem.getStyleClass()) == null ? "ui-menuitem-link" : "ui-menuitem-link " + (String)styleClass;
            styleClass = disabled ? (String)styleClass + " ui-state-disabled" : styleClass;
            writer.writeAttribute("class", styleClass, null);
            if (menuitem.getStyle() != null) {
                writer.writeAttribute("style", (Object)menuitem.getStyle(), null);
            }
            if (disabled) {
                writer.writeAttribute("href", (Object)"#", null);
                writer.writeAttribute("onclick", (Object)"return false;", null);
            } else {
                this.encodeOnClick(context, (UIComponent)button, menuitem);
            }
            if (icon != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)("ui-menuitem-icon ui-icon " + icon), null);
                writer.writeAttribute("aria-hidden", (Object)"true", null);
                writer.endElement("span");
            }
            if (menuitem.getValue() != null) {
                writer.startElement("span", null);
                writer.writeAttribute("class", (Object)"ui-menuitem-text", null);
                writer.writeText(menuitem.getValue(), "value");
                writer.endElement("span");
            }
            writer.endElement("a");
        }
    }

    protected void encodeSubmenu(FacesContext context, SplitButton button, Submenu submenu) throws IOException {
        if (!submenu.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        String label = submenu.getLabel();
        String style = submenu.getStyle();
        Object styleClass = submenu.getStyleClass();
        styleClass = styleClass == null ? "ui-widget-header" : "ui-widget-header " + (String)styleClass;
        writer.startElement("li", null);
        writer.writeAttribute("class", styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("h3", null);
        if (label != null) {
            writer.writeText((Object)label, "value");
        }
        writer.endElement("h3");
        writer.endElement("li");
        this.encodeElements(context, button, submenu.getElements(), true);
    }

    protected void encodeFilter(FacesContext context, SplitButton button) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String id = button.getClientId(context) + "_filter";
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"ui-splitbuttonmenu-filter-container", null);
        writer.startElement("input", null);
        writer.writeAttribute("class", (Object)"ui-splitbuttonmenu-filter ui-inputfield ui-inputtext ui-widget ui-state-default", null);
        writer.writeAttribute("id", (Object)id, null);
        writer.writeAttribute("name", (Object)id, null);
        writer.writeAttribute("type", (Object)"text", null);
        writer.writeAttribute("autocomplete", (Object)"off", null);
        if (button.getFilterPlaceholder() != null) {
            writer.writeAttribute("placeholder", (Object)button.getFilterPlaceholder(), null);
        }
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)"ui-icon ui-icon-search", id);
        writer.endElement("span");
        writer.endElement("input");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    protected boolean shouldBeRendered(FacesContext context, MenuItemAware container) {
        SplitButton button = (SplitButton)container;
        boolean rendered = button.getCustomOverlay() != null;
        rendered = rendered || super.shouldBeRendered(context, button);
        return rendered;
    }
}

