/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.steps;

import java.io.IOException;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.menu.AbstractMenu;
import org.primefaces.component.menu.BaseMenuRenderer;
import org.primefaces.component.steps.Steps;
import org.primefaces.model.menu.MenuElement;
import org.primefaces.model.menu.MenuItem;
import org.primefaces.util.LangUtils;
import org.primefaces.util.StyleClassBuilder;
import org.primefaces.util.WidgetBuilder;

public class StepsRenderer
extends BaseMenuRenderer {
    @Override
    protected void encodeMarkup(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        Steps steps = (Steps)abstractMenu;
        String clientId = steps.getClientId(context);
        String styleClass = steps.getStyleClass();
        String containerClass = steps.isReadonly() ? "ui-steps ui-steps-readonly ui-widget ui-helper-clearfix" : "ui-steps ui-widget ui-helper-clearfix";
        styleClass = styleClass == null ? containerClass : containerClass + " " + styleClass;
        int activeIndex = steps.getActiveIndex();
        List<MenuElement> elements = steps.getElements();
        writer.startElement("div", (UIComponent)steps);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("class", (Object)styleClass, "styleClass");
        if (steps.getStyle() != null) {
            writer.writeAttribute("style", (Object)steps.getStyle(), "style");
        }
        writer.startElement("ul", null);
        writer.writeAttribute("role", (Object)"tablist", null);
        int i = 0;
        if (elements != null && !elements.isEmpty()) {
            for (MenuElement element : elements) {
                if (!element.isRendered() || !(element instanceof MenuItem)) continue;
                this.encodeItem(context, steps, (MenuItem)element, activeIndex, i);
                ++i;
            }
        }
        writer.endElement("ul");
        writer.endElement("div");
    }

    protected void encodeItem(FacesContext context, Steps steps, MenuItem item, int activeIndex, int index) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String containerStyle = item.getContainerStyle();
        StyleClassBuilder containerStyleClass = this.getStyleClassBuilder(context).add(item.getContainerStyleClass());
        if (steps.isReadonly() || item.isDisabled()) {
            containerStyleClass.add(index == activeIndex, "ui-steps-item ui-state-highlight", "ui-steps-item ui-state-default ui-state-disabled");
        } else if (index == activeIndex) {
            containerStyleClass.add("ui-steps-item ui-state-highlight");
            containerStyleClass.add(steps.isActiveStepExecutable(), "ui-steps-item-executable");
        } else if (index < activeIndex) {
            containerStyleClass.add("ui-steps-item ui-state-default").add("ui-steps-item-executable");
        } else {
            containerStyleClass.add("ui-steps-item ui-state-default ui-state-disabled");
        }
        writer.startElement("li", null);
        writer.writeAttribute("class", (Object)containerStyleClass.build(), null);
        writer.writeAttribute("role", (Object)"tab", null);
        if (containerStyle != null) {
            writer.writeAttribute("style", (Object)containerStyle, null);
        }
        this.encodeMenuItem(context, steps, item, activeIndex, index);
        writer.endElement("li");
    }

    protected void encodeMenuItem(FacesContext context, Steps steps, MenuItem menuitem, int activeIndex, int index) throws IOException {
        boolean isDisabled;
        ResponseWriter writer = context.getResponseWriter();
        String title = menuitem.getTitle();
        String style = menuitem.getStyle();
        String styleClass = this.getLinkStyleClass(menuitem);
        writer.startElement("a", null);
        if (this.shouldRenderId(menuitem)) {
            writer.writeAttribute("id", (Object)menuitem.getClientId(), null);
        }
        if (title != null) {
            writer.writeAttribute("title", (Object)title, null);
        }
        writer.writeAttribute("class", (Object)styleClass, null);
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        boolean bl = steps.isActiveStepExecutable() ? activeIndex < index : (isDisabled = activeIndex <= index);
        if (steps.isReadonly() || menuitem.isDisabled() || isDisabled) {
            writer.writeAttribute("tabindex", (Object)"-1", null);
            writer.writeAttribute("href", (Object)"#", null);
            writer.writeAttribute("onclick", (Object)"return false;", null);
        } else {
            writer.writeAttribute("tabindex", (Object)steps.getTabindex(), null);
            this.encodeOnClick(context, (UIComponent)steps, menuitem);
        }
        writer.startElement("span", (UIComponent)steps);
        writer.writeAttribute("class", (Object)"ui-steps-number", null);
        if (LangUtils.isNotEmpty(menuitem.getIcon())) {
            writer.startElement("span", null);
            writer.writeAttribute("class", (Object)("ui-steps-number-icon " + menuitem.getIcon()), null);
            writer.endElement("span");
        } else {
            writer.writeText((Object)(index + 1), null);
        }
        writer.endElement("span");
        Object value = menuitem.getValue();
        if (value != null) {
            writer.startElement("span", (UIComponent)steps);
            writer.writeAttribute("class", (Object)"ui-steps-title", null);
            writer.writeText(value, null);
            writer.endElement("span");
        }
        writer.endElement("a");
    }

    @Override
    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    @Override
    protected void encodeScript(FacesContext context, AbstractMenu abstractMenu) throws IOException {
        Steps menu = (Steps)abstractMenu;
        WidgetBuilder wb = this.getWidgetBuilder(context);
        wb.init("Steps", menu);
        wb.finish();
    }
}

