/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.csp;

import javax.faces.application.ProjectStage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.primefaces.PrimeFaces;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.context.PrimeFacesContext;
import org.primefaces.csp.CspState;
import org.primefaces.shaded.owasp.encoder.Encode;
import org.primefaces.util.LangUtils;
import org.primefaces.util.Lazy;

public class CspPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private Lazy<Boolean> enabled = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().isCsp());
    private Lazy<Boolean> policyProvided = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().isPolicyProvided());
    private Lazy<String> customPolicy = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().getCspPolicy());
    private Lazy<String> reportOnlyPolicy = new Lazy(() -> PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getConfig().getCspReportOnlyPolicy());

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        CspPhaseListener.initCsp(context, this.enabled.get(), this.policyProvided.get(), this.reportOnlyPolicy.get(), this.customPolicy.get());
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }

    public static void initCsp(FacesContext context, Boolean enabled, Boolean policyProvided, String reportOnlyPolicy, String customPolicy) {
        Object policy;
        if (Boolean.FALSE.equals(enabled) || Boolean.TRUE.equals(policyProvided)) {
            return;
        }
        ExternalContext externalContext = context.getExternalContext();
        CspState state = PrimeFacesContext.getCspState(context);
        if (state.isInitialized()) {
            return;
        }
        state.setInitialized(true);
        if (LangUtils.isNotBlank(reportOnlyPolicy)) {
            policy = "script-src 'self' 'nonce-" + state.getNonce() + "'; " + reportOnlyPolicy + ";";
            externalContext.addResponseHeader("Content-Security-Policy-Report-Only", (String)policy);
        } else {
            policy = LangUtils.isBlank(customPolicy) ? "script-src 'self'" : customPolicy;
            policy = (String)policy + " 'nonce-" + state.getNonce() + "';";
            externalContext.addResponseHeader("Content-Security-Policy", (String)policy);
        }
        String init = "if(window.PrimeFaces){PrimeFaces.csp.init('" + Encode.forJavaScript(state.getNonce()) + "');}";
        if (context.isProjectStage(ProjectStage.Development)) {
            init = init + "else{console.log('CSP active but PrimeFaces not included in current view!');}";
        }
        PrimeFaces.current().executeInitScript(init);
    }
}

