/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.el;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import javax.faces.context.FacesContext;

public class ValueExpressionStateHelper
implements StateHelper {
    private static final Object UNKNOWN_VALUE = new Object();
    protected Map<String, Object> literals;
    protected Map<String, ValueExpression> bindings;
    private boolean transientFlag;

    public Object put(Serializable key, Object value) {
        if (this.literals == null) {
            this.literals = new HashMap<String, Object>(3);
        }
        return this.literals.put(String.valueOf(key), value);
    }

    public Object remove(Serializable key) {
        Object previous = this.eval(key);
        if (this.literals != null) {
            this.literals.remove(String.valueOf(key));
        }
        if (this.bindings != null) {
            this.bindings.remove(String.valueOf(key));
        }
        return previous;
    }

    public Object put(Serializable key, String mapKey, Object value) {
        HashMap<String, Object> internalMap = (HashMap<String, Object>)this.get(key);
        if (internalMap == null) {
            internalMap = new HashMap<String, Object>(3);
            this.put(key, internalMap);
        }
        return internalMap.put(mapKey, value);
    }

    public Object get(Serializable key) {
        if (this.literals == null) {
            return null;
        }
        return this.literals.get(String.valueOf(key));
    }

    public Object eval(Serializable key) {
        return this.eval(key, null);
    }

    public Object eval(Serializable key, Object defaultValue) {
        Object literal = this.get((Serializable)((Object)String.valueOf(key)));
        if (literal != null) {
            return literal;
        }
        if (this.bindings == null) {
            return defaultValue;
        }
        ValueExpression ve = this.bindings.get(String.valueOf(key));
        if (ve == null) {
            return defaultValue;
        }
        return ve.getValue(FacesContext.getCurrentInstance().getELContext());
    }

    public Object eval(Serializable key, Supplier<Object> defaultValueSupplier) {
        Object result = this.eval(key, UNKNOWN_VALUE);
        if (result == UNKNOWN_VALUE) {
            result = null;
            if (defaultValueSupplier != null) {
                result = defaultValueSupplier.get();
            }
        }
        return result;
    }

    public void add(Serializable key, Object value) {
        ArrayList<Object> internalList = (ArrayList<Object>)this.get(key);
        if (internalList == null) {
            internalList = new ArrayList<Object>(3);
            this.put(key, internalList);
        }
        internalList.add(value);
    }

    public Object remove(Serializable key, Object valueOrKey) {
        Object internalStructure = this.get(key);
        if (internalStructure instanceof List) {
            ((List)internalStructure).remove(valueOrKey);
            return null;
        }
        if (internalStructure instanceof Map) {
            return ((Map)internalStructure).remove(valueOrKey);
        }
        return null;
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.literals, this.bindings};
        return state;
    }

    public void restoreState(FacesContext context, Object state) {
        if (!(state instanceof Object[])) {
            return;
        }
        Object[] stateArray = (Object[])state;
        if (stateArray.length != 2) {
            return;
        }
        this.literals = (Map)stateArray[0];
        this.bindings = (Map)stateArray[1];
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }

    public void setBinding(String key, ValueExpression ve) {
        if (this.bindings == null) {
            this.bindings = new HashMap<String, ValueExpression>(3);
        }
        this.bindings.put(key, ve);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValueExpressionStateHelper that = (ValueExpressionStateHelper)o;
        return this.transientFlag == that.transientFlag && Objects.equals(this.literals, that.literals) && Objects.equals(this.bindings, that.bindings);
    }

    public int hashCode() {
        return Objects.hash(this.literals, this.bindings, this.transientFlag);
    }
}

