/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.expression;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.search.SearchExpressionContext;
import javax.faces.component.search.SearchKeywordContext;
import javax.faces.component.search.SearchKeywordResolver;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.context.FacesContext;
import org.primefaces.expression.WidgetVarVisitCallback;

public class WidgetVarSearchKeywordResolver
extends SearchKeywordResolver {
    private static final Pattern PATTERN = Pattern.compile("widgetVar\\(([\\w-_]+)\\)");

    public boolean isResolverForKeyword(SearchExpressionContext searchExpressionContext, String keyword) {
        return keyword != null && keyword.startsWith("widgetVar(");
    }

    public void resolve(SearchKeywordContext context, UIComponent current, String keyword) {
        block4: {
            try {
                Matcher matcher = PATTERN.matcher(keyword);
                if (matcher.matches()) {
                    FacesContext facesContext = context.getSearchExpressionContext().getFacesContext();
                    VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context.getSearchExpressionContext().getFacesContext(), null, (Set)context.getSearchExpressionContext().getVisitHints());
                    String widgetVar = matcher.group(1);
                    WidgetVarVisitCallback visitCallback = new WidgetVarVisitCallback(widgetVar);
                    facesContext.getViewRoot().visitTree(visitContext, (VisitCallback)visitCallback);
                    if (visitCallback.getComponent() != null) {
                        context.invokeContextCallback(visitCallback.getComponent());
                    }
                    break block4;
                }
                throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + keyword + "\"");
            }
            catch (Exception e) {
                throw new FacesException("Expression does not match following pattern @widgetVar(var). Expression: \"" + keyword + "\"", (Throwable)e);
            }
        }
    }

    public boolean isPassthrough(SearchExpressionContext searchExpressionContext, String keyword) {
        return true;
    }
}

