/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.facelets;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.MethodExpression;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

public class MethodRule
extends MetaRule {
    private final String methodName;
    private final Class<?> returnTypeClass;
    private final Class<?>[] params;

    public MethodRule(String methodName, Class<?> returnTypeClass, Class<?>[] params) {
        this.methodName = methodName;
        this.returnTypeClass = returnTypeClass;
        this.params = params;
    }

    public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
        Method method;
        if (!name.equals(this.methodName)) {
            return null;
        }
        Class type = meta.getPropertyType(name);
        if (MethodExpression.class.equals((Object)type) && (method = meta.getWriteMethod(name)) != null) {
            return new MethodExpressionMetadata(method, attribute, this.returnTypeClass, this.params);
        }
        return null;
    }

    private static class MethodExpressionMetadata
    extends Metadata {
        private final Method method;
        private final TagAttribute attribute;
        private final Class<?>[] paramList;
        private final Class<?> returnType;

        public MethodExpressionMetadata(Method method, TagAttribute attribute, Class<?> returnType, Class<?>[] paramList) {
            this.method = method;
            this.attribute = attribute;
            this.paramList = paramList;
            this.returnType = returnType;
        }

        public void applyMetadata(FaceletContext ctx, Object instance) {
            MethodExpression expr = this.attribute.getMethodExpression(ctx, this.returnType, (Class[])this.paramList);
            try {
                this.method.invoke(instance, expr);
            }
            catch (InvocationTargetException e) {
                throw new TagAttributeException(this.attribute, e.getCause());
            }
            catch (Exception e) {
                throw new TagAttributeException(this.attribute, (Throwable)e);
            }
        }
    }
}

