/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.metadata.transformer;

import java.io.IOException;
import java.util.List;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.PreRenderComponentEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.metadata.transformer.MetadataTransformer;
import org.primefaces.metadata.transformer.impl.BeanValidationInputMetadataTransformer;

public class MetadataTransformerExecutor
implements SystemEventListener {
    private static final MetadataTransformer BV_INPUT_METADATA_TRANSFORMER = new BeanValidationInputMetadataTransformer();

    public void processEvent(SystemEvent event) throws AbortProcessingException {
        try {
            if (event instanceof PreRenderComponentEvent) {
                PreRenderComponentEvent preRenderComponentEvent = (PreRenderComponentEvent)event;
                MetadataTransformerExecutor.execute(PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()), preRenderComponentEvent.getComponent());
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public boolean isListenerForSource(Object source) {
        return source instanceof UIComponent;
    }

    public static void execute(PrimeApplicationContext applicationContext, UIComponent component) throws IOException {
        if (applicationContext.getConfig().isTransformMetadataEnabled()) {
            FacesContext context = FacesContext.getCurrentInstance();
            if (applicationContext.getConfig().isBeanValidationEnabled()) {
                BV_INPUT_METADATA_TRANSFORMER.transform(context, applicationContext, component);
            }
            if (!applicationContext.getMetadataTransformers().isEmpty()) {
                for (int i = 0; i < applicationContext.getMetadataTransformers().size(); ++i) {
                    applicationContext.getMetadataTransformers().get(i).transform(context, applicationContext, component);
                }
            }
        }
    }

    public static void registerMetadataTransformer(MetadataTransformer metadataTransformer) {
        PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getMetadataTransformers().add(metadataTransformer);
    }

    public static MetadataTransformer removeMetadataTransformer(Class<? extends MetadataTransformer> clazz) {
        List<MetadataTransformer> transformers = PrimeApplicationContext.getCurrentInstance(FacesContext.getCurrentInstance()).getMetadataTransformers();
        MetadataTransformer transformer = transformers.stream().filter(t -> t.getClass().equals(clazz)).findFirst().orElse(null);
        if (transformer != null) {
            transformers.remove(transformer);
        }
        return transformer;
    }
}

