/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.primefaces.model.ScheduleDisplayMode;
import org.primefaces.model.ScheduleEvent;

public class DefaultScheduleEvent<T>
implements ScheduleEvent<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private T data;
    private String groupId;
    private String title;
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private boolean allDay;
    private boolean overlapAllowed;
    private Boolean resizable;
    private Boolean draggable;
    private String styleClass;
    private String description;
    private String url;
    private ScheduleDisplayMode display;
    private String backgroundColor;
    private String borderColor;
    private String textColor;
    private Map<String, Object> dynamicProperties;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @Override
    public void setStartDate(LocalDateTime startDate) {
        this.startDate = startDate;
    }

    @Override
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    @Override
    public void setEndDate(LocalDateTime endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean isAllDay() {
        return this.allDay;
    }

    @Override
    public void setAllDay(boolean allDay) {
        this.allDay = allDay;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    @Override
    public String getStyleClass() {
        return this.styleClass;
    }

    @Override
    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public Boolean isDraggable() {
        return this.draggable;
    }

    @Override
    public Boolean isResizable() {
        return this.resizable;
    }

    @Override
    public boolean isOverlapAllowed() {
        return this.overlapAllowed;
    }

    public void setOverlapAllowed(boolean overlapAllowed) {
        this.overlapAllowed = overlapAllowed;
    }

    public void setEditable(boolean editable) {
        this.draggable = editable;
        this.resizable = editable;
    }

    public void setDraggable(Boolean draggable) {
        this.draggable = draggable;
    }

    public void setResizable(Boolean resizable) {
        this.resizable = resizable;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public ScheduleDisplayMode getDisplay() {
        return this.display;
    }

    public void setDisplay(ScheduleDisplayMode display) {
        this.display = display;
    }

    @Override
    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public String getTextColor() {
        return this.textColor;
    }

    public void setTextColor(String textColor) {
        this.textColor = textColor;
    }

    @Override
    public Map<String, Object> getDynamicProperties() {
        return this.dynamicProperties;
    }

    public Object setDynamicProperty(String key, Object value) {
        if (this.dynamicProperties == null) {
            this.dynamicProperties = new HashMap<String, Object>();
        }
        return this.dynamicProperties.put(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultScheduleEvent that = (DefaultScheduleEvent)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.startDate, this.endDate);
    }

    public String toString() {
        return "DefaultScheduleEvent{title=" + this.title + ",startDate=" + String.valueOf(this.startDate) + ",endDate=" + String.valueOf(this.endDate) + "}";
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static final class Builder<T> {
        private final DefaultScheduleEvent<T> scheduleEvent = new DefaultScheduleEvent();

        private Builder() {
        }

        public Builder<T> id(String id) {
            this.scheduleEvent.setId(id);
            return this;
        }

        public Builder<T> groupId(String groupId) {
            this.scheduleEvent.setGroupId(groupId);
            return this;
        }

        public Builder<T> title(String title) {
            this.scheduleEvent.setTitle(title);
            return this;
        }

        public Builder<T> startDate(LocalDateTime startDate) {
            this.scheduleEvent.setStartDate(startDate);
            return this;
        }

        public Builder<T> endDate(LocalDateTime endDate) {
            this.scheduleEvent.setEndDate(endDate);
            return this;
        }

        public Builder<T> allDay(boolean allDay) {
            this.scheduleEvent.setAllDay(allDay);
            return this;
        }

        public Builder<T> styleClass(String styleClass) {
            this.scheduleEvent.setStyleClass(styleClass);
            return this;
        }

        public Builder<T> data(T data) {
            this.scheduleEvent.setData(data);
            return this;
        }

        public Builder<T> editable(boolean editable) {
            this.scheduleEvent.setEditable(editable);
            return this;
        }

        public Builder<T> draggable(Boolean draggable) {
            this.scheduleEvent.setDraggable(draggable);
            return this;
        }

        public Builder<T> resizable(Boolean resizable) {
            this.scheduleEvent.setResizable(resizable);
            return this;
        }

        public Builder<T> overlapAllowed(boolean overlapAllowed) {
            this.scheduleEvent.setOverlapAllowed(overlapAllowed);
            return this;
        }

        public Builder<T> description(String description) {
            this.scheduleEvent.setDescription(description);
            return this;
        }

        public Builder<T> url(String url) {
            this.scheduleEvent.setUrl(url);
            return this;
        }

        public Builder<T> dynamicProperty(String key, Object value) {
            this.scheduleEvent.setDynamicProperty(key, value);
            return this;
        }

        public Builder<T> display(ScheduleDisplayMode display) {
            this.scheduleEvent.setDisplay(display);
            return this;
        }

        public Builder<T> backgroundColor(String backgroundColor) {
            this.scheduleEvent.setBackgroundColor(backgroundColor);
            return this;
        }

        public Builder<T> borderColor(String borderColor) {
            this.scheduleEvent.setBorderColor(borderColor);
            return this;
        }

        public Builder<T> textColor(String textColor) {
            this.scheduleEvent.setTextColor(textColor);
            return this;
        }

        public DefaultScheduleEvent<T> build() {
            return this.scheduleEvent;
        }
    }
}

