/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.util.List;
import org.primefaces.model.DefaultTreeNodeChildren;
import org.primefaces.model.TreeNode;
import org.primefaces.model.TreeNodeChildren;

public class DefaultTreeNode<T>
implements TreeNode<T>,
Serializable {
    public static final String DEFAULT_TYPE = "default";
    private static final long serialVersionUID = 1L;
    protected String type;
    protected T data;
    protected TreeNodeChildren<T> children;
    protected TreeNode parent;
    protected boolean expanded;
    protected boolean selected;
    protected boolean selectable = true;
    protected String rowKey;

    public DefaultTreeNode() {
        this(null);
    }

    public DefaultTreeNode(T data) {
        this(data, null);
    }

    public DefaultTreeNode(T data, TreeNode parent) {
        this(DEFAULT_TYPE, data, parent);
    }

    public DefaultTreeNode(String type, T data, TreeNode parent) {
        this.type = type;
        this.data = data;
        this.children = this.initChildren();
        if (parent != null) {
            parent.getChildren().add(this);
        }
    }

    protected TreeNodeChildren<T> initChildren() {
        return new DefaultTreeNodeChildren(this);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public TreeNodeChildren<T> getChildren() {
        return this.children;
    }

    public void setChildren(List<TreeNode<T>> children) {
        if (children instanceof TreeNodeChildren) {
            this.children = (TreeNodeChildren)children;
        } else {
            this.children = this.initChildren();
            this.children.addAll(children);
        }
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TreeNode parent) {
        this.parent = parent;
    }

    @Override
    public void clearParent() {
        this.parent = null;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean value) {
        this.selected = value;
    }

    @Override
    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public boolean isLeaf() {
        if (this.children == null) {
            return true;
        }
        return this.children.isEmpty();
    }

    @Override
    public String getRowKey() {
        return this.rowKey;
    }

    @Override
    public void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.rowKey == null ? 0 : this.rowKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTreeNode other = (DefaultTreeNode)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        if (this.rowKey == null) {
            return other.rowKey == null;
        }
        return this.rowKey.equals(other.rowKey);
    }

    public String toString() {
        if (this.data != null) {
            return this.data.toString();
        }
        return super.toString();
    }

    @Override
    public boolean isPartialSelected() {
        return false;
    }

    @Override
    public void setPartialSelected(boolean value) {
    }
}

