/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Objects;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import org.primefaces.component.api.DynamicColumn;
import org.primefaces.component.api.UIColumn;
import org.primefaces.component.column.ColumnBase;
import org.primefaces.model.MatchMode;
import org.primefaces.model.filter.FilterConstraint;
import org.primefaces.model.filter.FilterConstraints;
import org.primefaces.model.filter.FunctionFilterConstraint;
import org.primefaces.model.filter.GlobalFilterConstraint;
import org.primefaces.util.EditableValueHolderState;
import org.primefaces.util.LangUtils;

public class FilterMeta
implements Serializable {
    public static final String GLOBAL_FILTER_KEY = "globalFilter";
    private static final long serialVersionUID = 1L;
    private String field;
    private String columnKey;
    private ValueExpression filterBy;
    private Object filterValue;
    private MatchMode matchMode = MatchMode.CONTAINS;
    private FilterConstraint constraint;
    private boolean normalize = false;
    private boolean filterByGenerated;

    public FilterMeta() {
    }

    FilterMeta(String columnKey, String field, FilterConstraint constraint, ValueExpression filterBy, Object filterValue, MatchMode matchMode, boolean normalize, boolean filterByGenerated) {
        this.field = field;
        this.columnKey = columnKey;
        this.filterBy = filterBy;
        this.constraint = constraint;
        this.matchMode = matchMode;
        this.normalize = normalize;
        this.filterByGenerated = filterByGenerated;
        this.setFilterValue(filterValue);
    }

    public static FilterMeta of(FacesContext context, String var, UIColumn column, boolean normalize) {
        EditableValueHolderState state;
        Object filterValue;
        if (column instanceof DynamicColumn) {
            ((DynamicColumn)column).applyStatelessModel();
        }
        if (!column.isFilterable()) {
            return null;
        }
        String field = column.getField();
        ValueExpression filterByVE = column.getValueExpression(ColumnBase.PropertyKeys.filterBy.name());
        if (field == null && filterByVE == null) {
            return null;
        }
        boolean filterByGenerated = false;
        if (field == null) {
            field = column.resolveField(context, filterByVE);
        } else if (filterByVE == null) {
            filterByVE = UIColumn.createValueExpressionFromField(context, var, field);
            filterByGenerated = true;
        }
        MatchMode matchMode = MatchMode.of(column.getFilterMatchMode());
        FilterConstraint constraint = FilterConstraints.of(matchMode);
        if (column.getFilterFunction() != null) {
            constraint = new FunctionFilterConstraint(column.getFilterFunction());
        }
        if ((filterValue = column.getFilterValue()) == null && (state = column.getFilterValueHolder(context)) != null) {
            filterValue = state.getValue();
        }
        filterValue = LangUtils.normalize(filterValue, normalize);
        return new FilterMeta(column.getColumnKey(), field, constraint, filterByVE, filterValue, matchMode, normalize, filterByGenerated);
    }

    public static FilterMeta of(Object globalFilterValue, MethodExpression globalFilterFunction, boolean normalize) {
        FilterConstraint constraint = globalFilterFunction == null ? new GlobalFilterConstraint() : new FunctionFilterConstraint(globalFilterFunction);
        return new FilterMeta(GLOBAL_FILTER_KEY, GLOBAL_FILTER_KEY, constraint, null, LangUtils.normalize(globalFilterValue, normalize), MatchMode.GLOBAL, normalize, false);
    }

    public static <T> T resetToNullIfEmpty(T filterValue) {
        if (filterValue != null && (filterValue instanceof String && LangUtils.isBlank((String)filterValue) || filterValue instanceof Collection && ((Collection)filterValue).isEmpty() || filterValue instanceof Iterable && !((Iterable)filterValue).iterator().hasNext() || filterValue.getClass().isArray() && Array.getLength(filterValue) == 0)) {
            filterValue = null;
        }
        return filterValue;
    }

    public String getField() {
        return this.field;
    }

    public String getColumnKey() {
        return this.columnKey;
    }

    public ValueExpression getFilterBy() {
        return this.filterBy;
    }

    public void setFilterBy(ValueExpression filterBy) {
        this.filterBy = filterBy;
        this.filterByGenerated = false;
    }

    public Object getFilterValue() {
        return this.filterValue;
    }

    public void setFilterValue(Object filterValue) {
        this.filterValue = FilterMeta.resetToNullIfEmpty(LangUtils.normalize(filterValue, this.isNormalize()));
    }

    public FilterConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(FilterConstraint constraint) {
        this.constraint = constraint;
    }

    public boolean isActive() {
        return this.filterValue != null;
    }

    public MatchMode getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(MatchMode matchMode) {
        this.matchMode = matchMode;
    }

    public boolean isGlobalFilter() {
        return GLOBAL_FILTER_KEY.equals(this.columnKey);
    }

    public Object getLocalValue(ELContext elContext, UIColumn column) {
        if (column instanceof DynamicColumn) {
            ((DynamicColumn)column).applyStatelessModel();
        }
        return LangUtils.normalize(this.filterBy.getValue(elContext), this.isNormalize());
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean isFilterByGenerated() {
        return this.filterByGenerated;
    }

    public void setFilterByGenerated(boolean filterByGenerated) {
        this.filterByGenerated = filterByGenerated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "FilterMeta{field='" + this.field + "', columnKey='" + this.columnKey + "', filterBy=" + String.valueOf(this.filterBy) + ", filterValue=" + String.valueOf(this.filterValue) + ", matchMode=" + String.valueOf((Object)this.matchMode) + ", constraint=" + String.valueOf(this.constraint) + ", normalize=" + this.normalize + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterMeta that = (FilterMeta)o;
        return Objects.equals(this.field, that.field) && Objects.equals(this.columnKey, that.columnKey);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.columnKey);
    }

    public static final class Builder {
        private final FilterMeta filterBy = new FilterMeta();

        private Builder() {
        }

        public Builder field(String field) {
            this.filterBy.field = field;
            return this;
        }

        public Builder filterBy(ValueExpression filterBy) {
            this.filterBy.filterBy = filterBy;
            return this;
        }

        public Builder filterValue(Object filterValue) {
            this.filterBy.filterValue = filterValue;
            return this;
        }

        public Builder constraint(FilterConstraint constraint) {
            this.filterBy.constraint = constraint;
            return this;
        }

        public Builder matchMode(MatchMode matchMode) {
            this.filterBy.matchMode = matchMode;
            return this;
        }

        public Builder normalize(boolean normalize) {
            this.filterBy.normalize = normalize;
            return this;
        }

        public FilterMeta build() {
            if (this.filterBy.matchMode != null) {
                this.filterBy.constraint = FilterConstraints.of(this.filterBy.matchMode);
            }
            this.filterBy.filterValue = FilterMeta.resetToNullIfEmpty(this.filterBy.filterValue);
            Objects.requireNonNull(this.filterBy.constraint, "Filter constraint is required");
            Objects.requireNonNull(this.filterBy.field, "Field is required");
            return this.filterBy;
        }
    }
}

