/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.primefaces.context.PrimeApplicationContext;
import org.primefaces.model.FilterMeta;
import org.primefaces.model.LazyDataModel;
import org.primefaces.model.SortMeta;
import org.primefaces.model.SortOrder;
import org.primefaces.util.BeanUtils;
import org.primefaces.util.Callbacks;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LocaleUtils;
import org.primefaces.util.PropertyDescriptorResolver;

public class JPALazyDataModel<T>
extends LazyDataModel<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(JPALazyDataModel.class.getName());
    protected Class<T> entityClass;
    protected String rowKeyField;
    protected boolean caseSensitive = true;
    protected boolean wildcardSupport = false;
    protected Class<?> rowKeyType;
    protected QueryEnricher<T> queryEnricher;
    protected FilterEnricher<T> filterEnricher;
    protected AdditionalFilterMeta additionalFilterMeta;
    protected SortEnricher<T> sortEnricher;
    protected Callbacks.SerializableSupplier<EntityManager> entityManager;
    protected Callbacks.SerializableFunction<T, Object> rowKeyProvider;
    protected Callbacks.SerializableConsumer<List<T>> resultEnricher;

    @Override
    public int count(Map<String, FilterMeta> filterBy) {
        EntityManager em = (EntityManager)this.entityManager.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(Long.class);
        Root root = cq.from(this.entityClass);
        cq = cq.select((Selection)cb.count((Expression)root));
        this.applyFilters(cb, cq, root, filterBy);
        TypedQuery query = em.createQuery(cq);
        return ((Long)query.getSingleResult()).intValue();
    }

    @Override
    public List<T> load(int first, int pageSize, Map<String, SortMeta> sortBy, Map<String, FilterMeta> filterBy) {
        EntityManager em = (EntityManager)this.entityManager.get();
        CriteriaBuilder cb = em.getCriteriaBuilder();
        CriteriaQuery cq = cb.createQuery(this.entityClass);
        Root root = cq.from(this.entityClass);
        cq = cq.select((Selection)root);
        this.applyFilters(cb, cq, root, filterBy);
        this.applySort(cb, cq, root, sortBy);
        TypedQuery query = em.createQuery(cq);
        query.setFirstResult(first);
        query.setMaxResults(pageSize);
        if (this.queryEnricher != null) {
            this.queryEnricher.enrich(query);
        }
        List result = query.getResultList();
        if (this.resultEnricher != null) {
            this.resultEnricher.accept(result);
        }
        return result;
    }

    protected void applyFilters(CriteriaBuilder cb, CriteriaQuery<?> cq, Root<T> root, Map<String, FilterMeta> filterBy) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        this.applyFiltersFromFilterMeta(this.entityClass, filterBy.values(), cb, cq, root, predicates);
        if (this.filterEnricher != null) {
            this.filterEnricher.enrich(filterBy, cb, cq, root, predicates);
        }
        if (this.additionalFilterMeta != null) {
            this.applyFiltersFromFilterMeta(this.entityClass, this.additionalFilterMeta.process(), cb, cq, root, predicates);
        }
        if (!predicates.isEmpty()) {
            cq.where((Expression)cb.and(predicates.toArray(new Predicate[0])));
        }
    }

    protected void applyFiltersFromFilterMeta(Class<T> entityClass, Collection<FilterMeta> filterBy, CriteriaBuilder cb, CriteriaQuery<?> cq, Root<T> root, List<Predicate> predicates) {
        if (filterBy != null) {
            FacesContext context = FacesContext.getCurrentInstance();
            Locale locale = LocaleUtils.getCurrentLocale(context);
            PropertyDescriptorResolver propResolver = PrimeApplicationContext.getCurrentInstance(context).getPropertyDescriptorResolver();
            for (FilterMeta filter : filterBy) {
                if (filter.getField() == null || filter.getFilterValue() == null || filter.isGlobalFilter()) continue;
                PropertyDescriptor pd = propResolver.get(entityClass, filter.getField());
                Object filterValue = filter.getFilterValue();
                Class<?> filterValueClass = filterValue.getClass();
                Object convertedFilterValue = filterValueClass.isArray() || Collection.class.isAssignableFrom(filterValueClass) ? filterValue : ComponentUtils.convertToType(filterValue, pd.getPropertyType(), LOGGER);
                Expression fieldExpression = this.resolveFieldExpression(cb, cq, root, filter.getField());
                Predicate predicate = this.createPredicate(filter, pd, root, cb, fieldExpression, convertedFilterValue, locale);
                predicates.add(predicate);
            }
        }
    }

    protected Predicate createPredicate(FilterMeta filter, PropertyDescriptor pd, Root<T> root, CriteriaBuilder cb, Expression fieldExpression, Object filterValue, Locale locale) {
        boolean isCaseSensitive = this.caseSensitive || !CharSequence.class.isAssignableFrom(pd.getPropertyType()) && pd.getPropertyType() != Character.TYPE;
        Supplier<Expression> fieldExpressionAsString = () -> isCaseSensitive ? fieldExpression.as(String.class) : cb.upper(fieldExpression.as(String.class));
        Supplier<Collection> filterValueAsCollection = () -> filterValue.getClass().isArray() ? Arrays.asList((Object[])filterValue) : (List<Object>)filterValue;
        switch (filter.getMatchMode()) {
            case STARTS_WITH: {
                return cb.like(fieldExpressionAsString.get(), this.getStringFilterValue(filterValue, locale) + "%");
            }
            case NOT_STARTS_WITH: {
                return cb.notLike(fieldExpressionAsString.get(), this.getStringFilterValue(filterValue, locale) + "%");
            }
            case ENDS_WITH: {
                return cb.like(fieldExpressionAsString.get(), "%" + this.getStringFilterValue(filterValue, locale));
            }
            case NOT_ENDS_WITH: {
                return cb.notLike(fieldExpressionAsString.get(), "%" + this.getStringFilterValue(filterValue, locale));
            }
            case CONTAINS: {
                return cb.like(fieldExpressionAsString.get(), "%" + this.getStringFilterValue(filterValue, locale) + "%");
            }
            case NOT_CONTAINS: {
                return cb.notLike(fieldExpressionAsString.get(), "%" + this.getStringFilterValue(filterValue, locale) + "%");
            }
            case EXACT: {
                String exactValue = this.getStringFilterValue(filterValue, locale);
                if (this.wildcardSupport && (exactValue.contains("%") || exactValue.contains("_"))) {
                    return cb.like(fieldExpressionAsString.get(), exactValue);
                }
                return cb.equal(fieldExpressionAsString.get(), (Object)exactValue);
            }
            case EQUALS: {
                return cb.equal(fieldExpression, filterValue);
            }
            case NOT_EXACT: 
            case NOT_EQUALS: {
                return cb.notEqual(fieldExpression, filterValue);
            }
            case LESS_THAN: {
                return cb.lessThan(fieldExpression, (Comparable)filterValue);
            }
            case LESS_THAN_EQUALS: {
                return cb.lessThanOrEqualTo(fieldExpression, (Comparable)filterValue);
            }
            case GREATER_THAN: {
                return cb.greaterThan(fieldExpression, (Comparable)filterValue);
            }
            case GREATER_THAN_EQUALS: {
                return cb.greaterThanOrEqualTo(fieldExpression, (Comparable)filterValue);
            }
            case IN: {
                return filterValueAsCollection.get().size() == 1 ? cb.equal(fieldExpression, filterValueAsCollection.get().iterator().next()) : fieldExpression.in(filterValueAsCollection.get());
            }
            case NOT_IN: {
                return filterValueAsCollection.get().size() == 1 ? cb.notEqual(fieldExpression, filterValueAsCollection.get().iterator().next()) : fieldExpression.in(filterValueAsCollection.get()).not();
            }
            case BETWEEN: {
                Iterator iterBetween = filterValueAsCollection.get().iterator();
                return cb.and((Expression)cb.greaterThanOrEqualTo(fieldExpression, (Comparable)iterBetween.next()), (Expression)cb.lessThanOrEqualTo(fieldExpression, (Comparable)iterBetween.next()));
            }
            case NOT_BETWEEN: {
                Iterator iterNotBetween = filterValueAsCollection.get().iterator();
                return cb.and((Expression)cb.greaterThanOrEqualTo(fieldExpression, (Comparable)iterNotBetween.next()), (Expression)cb.lessThanOrEqualTo(fieldExpression, (Comparable)iterNotBetween.next())).not();
            }
            case GLOBAL: {
                throw new UnsupportedOperationException("MatchMode.GLOBAL currently not supported!");
            }
        }
        return null;
    }

    protected String getStringFilterValue(Object filterValue, Locale locale) {
        String value = Objects.toString(filterValue, "");
        String string = value = this.caseSensitive ? value : value.toUpperCase(locale);
        if (this.wildcardSupport) {
            value = value.replace("*", "%");
            value = value.replace("?", "_");
        }
        return value;
    }

    protected void applySort(CriteriaBuilder cb, CriteriaQuery<T> cq, Root<T> root, Map<String, SortMeta> sortBy) {
        ArrayList<Order> orders = new ArrayList<Order>();
        if (sortBy != null) {
            for (SortMeta sort : sortBy.values().stream().sorted().collect(Collectors.toList())) {
                if (sort.getField() == null || sort.getOrder() == SortOrder.UNSORTED) continue;
                Expression fieldExpression = this.resolveFieldExpression(cb, cq, root, sort.getField());
                orders.add(sort.getOrder() == SortOrder.ASCENDING ? cb.asc(fieldExpression) : cb.desc(fieldExpression));
            }
        }
        if (this.sortEnricher != null) {
            this.sortEnricher.enrich(sortBy, cb, cq, root, orders);
        }
        if (!orders.isEmpty()) {
            cq.orderBy(orders);
        }
    }

    protected Expression resolveFieldExpression(CriteriaBuilder cb, CriteriaQuery<?> cq, Root<T> root, String fieldName) {
        Join join = null;
        while (fieldName.contains(".")) {
            String currentName = fieldName.substring(0, fieldName.indexOf("."));
            fieldName = fieldName.substring(currentName.length() + 1);
            if (join == null) {
                join = root.join(currentName, JoinType.INNER);
                continue;
            }
            join = join.join(currentName, JoinType.INNER);
        }
        return join == null ? root.get(fieldName) : join.get(fieldName);
    }

    @Override
    public T getRowData(String rowKey) {
        if (this.rowKeyConverter != null) {
            return super.getRowData(rowKey);
        }
        Object convertedRowKey = ComponentUtils.convertToType(rowKey, this.rowKeyType, LOGGER);
        EntityManager em = (EntityManager)this.entityManager.get();
        CriteriaBuilder criteriaBuilder = em.getCriteriaBuilder();
        CriteriaQuery cq = criteriaBuilder.createQuery(this.entityClass);
        Root root = cq.from(this.entityClass);
        cq.select((Selection)root).where((Expression)criteriaBuilder.equal((Expression)root.get(this.rowKeyField), convertedRowKey));
        TypedQuery query = em.createQuery(cq);
        Object result = query.getSingleResult();
        if (this.resultEnricher != null) {
            this.resultEnricher.accept(List.of(result));
        }
        return (T)result;
    }

    @Override
    public String getRowKey(T obj) {
        Object rowKey = this.rowKeyProvider.apply(obj);
        return rowKey == null ? null : String.valueOf(rowKey);
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @FunctionalInterface
    public static interface QueryEnricher<T>
    extends Serializable {
        public void enrich(TypedQuery<T> var1);
    }

    @FunctionalInterface
    public static interface FilterEnricher<T>
    extends Serializable {
        public void enrich(Map<String, FilterMeta> var1, CriteriaBuilder var2, CriteriaQuery<?> var3, Root<T> var4, List<Predicate> var5);
    }

    @FunctionalInterface
    public static interface AdditionalFilterMeta
    extends Serializable {
        public Collection<FilterMeta> process();
    }

    @FunctionalInterface
    public static interface SortEnricher<T>
    extends Serializable {
        public void enrich(Map<String, SortMeta> var1, CriteriaBuilder var2, CriteriaQuery<T> var3, Root<T> var4, List<Order> var5);
    }

    public static class Builder<T> {
        private final JPALazyDataModel<T> model = new JPALazyDataModel();

        public Builder<T> entityClass(Class<T> entityClass) {
            this.model.entityClass = entityClass;
            return this;
        }

        public Builder<T> entityManager(Callbacks.SerializableSupplier<EntityManager> entityManager) {
            this.model.entityManager = entityManager;
            return this;
        }

        public Builder<T> rowKeyConverter(Converter<T> rowKeyConverter) {
            this.model.rowKeyConverter = rowKeyConverter;
            return this;
        }

        public Builder<T> rowKeyProvider(Callbacks.SerializableFunction<T, Object> rowKeyProvider) {
            this.model.rowKeyProvider = rowKeyProvider;
            return this;
        }

        public Builder<T> rowKeyField(String rowKey) {
            this.model.rowKeyField = rowKey;
            return this;
        }

        public Builder<T> rowKeyField(SingularAttribute<T, ?> rowKeyMetamodel) {
            this.model.rowKeyField = rowKeyMetamodel.getName();
            this.model.rowKeyType = rowKeyMetamodel.getJavaType();
            return this;
        }

        public Builder<T> rowKeyType(Class<?> rowKeyType) {
            this.model.rowKeyType = rowKeyType;
            return this;
        }

        public Builder<T> caseSensitive(boolean caseSensitive) {
            this.model.caseSensitive = caseSensitive;
            return this;
        }

        public Builder<T> wildcardSupport(boolean wildcardSupport) {
            this.model.wildcardSupport = wildcardSupport;
            return this;
        }

        public Builder<T> queryEnricher(QueryEnricher<T> queryEnricher) {
            this.model.queryEnricher = queryEnricher;
            return this;
        }

        public Builder<T> filterEnricher(FilterEnricher<T> filterEnricher) {
            this.model.filterEnricher = filterEnricher;
            return this;
        }

        public Builder<T> additionalFilterMeta(AdditionalFilterMeta additionalFilterMeta) {
            this.model.additionalFilterMeta = additionalFilterMeta;
            return this;
        }

        public Builder<T> sortEnricher(SortEnricher<T> sortEnricher) {
            this.model.sortEnricher = sortEnricher;
            return this;
        }

        public Builder<T> resultEnricher(Callbacks.SerializableConsumer<List<T>> resultEnricher) {
            this.model.resultEnricher = resultEnricher;
            return this;
        }

        public JPALazyDataModel<T> build() {
            Objects.requireNonNull(this.model.entityClass, "entityClass not set");
            Objects.requireNonNull(this.model.entityManager, "entityManager not set");
            if (this.model.rowKeyConverter != null) {
                this.model.rowKeyProvider = this.model::getRowKeyFromConverter;
            } else {
                FacesContext context = FacesContext.getCurrentInstance();
                if (this.model.rowKeyField == null) {
                    Converter converter;
                    EntityManagerFactory emf = ((EntityManager)this.model.entityManager.get()).getEntityManagerFactory();
                    EntityType entityType = emf.getMetamodel().entity(this.model.entityClass);
                    Type idType = entityType.getIdType();
                    if (idType.getPersistenceType() != Type.PersistenceType.BASIC) {
                        throw new FacesException("Entity @Id is not a basic type. Define a rowKeyField!");
                    }
                    if (!BeanUtils.isPrimitiveOrPrimitiveWrapper(idType.getJavaType()) && (converter = context.getApplication().createConverter(idType.getJavaType())) == null) {
                        throw new FacesException("Entity @Id is not a primitive and no Converter found for " + idType.getJavaType().getName() + "! Either define a rowKeyField or create a JSF Converter for it!");
                    }
                    SingularAttribute idAttribute = entityType.getId(idType.getJavaType());
                    this.model.rowKeyField = idAttribute.getName();
                    if (this.model.rowKeyType == null) {
                        this.model.rowKeyType = idType.getJavaType();
                    }
                    if (this.model.rowKeyProvider == null) {
                        this.model.rowKeyProvider = obj -> emf.getPersistenceUnitUtil().getIdentifier(obj);
                    }
                } else {
                    PropertyDescriptorResolver propResolver = PrimeApplicationContext.getCurrentInstance(context).getPropertyDescriptorResolver();
                    if (this.model.rowKeyType == null) {
                        this.model.rowKeyType = propResolver.get(this.model.entityClass, this.model.rowKeyField).getPropertyType();
                    }
                    if (this.model.rowKeyProvider == null) {
                        this.model.rowKeyProvider = obj -> propResolver.getValue(obj, this.model.rowKeyField);
                    }
                }
            }
            return this.model;
        }
    }
}

