/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model;

import java.util.List;
import java.util.stream.Collectors;
import org.primefaces.model.DefaultTreeNode;
import org.primefaces.model.LazyDefaultTreeNodeChildren;
import org.primefaces.model.LazyTreeNode;
import org.primefaces.model.TreeNodeChildren;
import org.primefaces.util.Callbacks;

public class LazyDefaultTreeNode<T>
extends DefaultTreeNode<T>
implements LazyTreeNode {
    private static final long serialVersionUID = 1L;
    private Callbacks.SerializableFunction<T, List<T>> loadFunction;
    private Callbacks.SerializableFunction<T, Boolean> isLeafFunction;
    private boolean loaded;

    public LazyDefaultTreeNode() {
    }

    public LazyDefaultTreeNode(T data, Callbacks.SerializableFunction<T, List<T>> loadFunction, Callbacks.SerializableFunction<T, Boolean> isLeafFunction) {
        super(data);
        this.loadFunction = loadFunction;
        this.isLeafFunction = isLeafFunction;
    }

    @Override
    public TreeNodeChildren<T> getChildren() {
        if (this.isLeaf()) {
            return null;
        }
        this.lazyLoad();
        return super.getChildren();
    }

    @Override
    public int getChildCount() {
        if (this.isLeaf()) {
            return 0;
        }
        this.lazyLoad();
        return super.getChildCount();
    }

    @Override
    public boolean isLeaf() {
        return (Boolean)this.isLeafFunction.apply(this.getData());
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    protected void lazyLoad() {
        if (!this.loaded) {
            this.loaded = true;
            List childData = (List)this.loadFunction.apply(this.getData());
            List childNodes = childData.stream().map(f -> new LazyDefaultTreeNode<Object>(f, this.loadFunction, this.isLeafFunction)).collect(Collectors.toList());
            super.getChildren().addAll(childNodes);
        }
    }

    @Override
    protected LazyDefaultTreeNodeChildren<T> initChildren() {
        return new LazyDefaultTreeNodeChildren(this);
    }
}

