/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.model.diagram.overlay;

import java.io.Serializable;
import org.primefaces.model.diagram.overlay.Overlay;
import org.primefaces.util.EscapeUtils;

public class LabelOverlay
implements Overlay,
Serializable {
    private static final long serialVersionUID = 1L;
    private String label;
    private String styleClass;
    private double location = 0.5;

    public LabelOverlay() {
    }

    public LabelOverlay(String label) {
        this.label = label;
    }

    public LabelOverlay(String label, String styleClass, double location) {
        this(label);
        this.styleClass = styleClass;
        this.location = location;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public double getLocation() {
        return this.location;
    }

    public void setLocation(double location) {
        this.location = location;
    }

    @Override
    public String getType() {
        return "Label";
    }

    @Override
    public String toJS(StringBuilder sb) {
        sb.append("['Label',{label:\"").append(EscapeUtils.forJavaScript(this.label)).append("\"");
        if (this.styleClass != null) {
            sb.append(",cssClass:'").append(this.styleClass).append("'");
        }
        if (this.location != 0.5) {
            sb.append(",location:").append(this.location);
        }
        sb.append("}]");
        return sb.toString();
    }
}

