/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.util.Objects;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.primefaces.component.api.InputHolder;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.util.LangUtils;
import org.primefaces.util.SharedStringBuilder;

public abstract class InputRenderer
extends CoreRenderer {
    private static final String SB_STYLECLASS = InputRenderer.class.getName() + "#createStyleClass";

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        Converter converter = ComponentUtils.getConverter(context, component);
        if (converter != null) {
            String convertableValue = submittedValue == null ? null : submittedValue.toString();
            return converter.getAsObject(context, component, convertableValue);
        }
        return submittedValue;
    }

    protected boolean isDisabled(UIInput component) {
        return Boolean.parseBoolean(String.valueOf(component.getAttributes().get("disabled")));
    }

    protected boolean isReadOnly(UIInput component) {
        return Boolean.parseBoolean(String.valueOf(component.getAttributes().get("readonly")));
    }

    protected boolean shouldDecode(UIInput component) {
        return !this.isDisabled(component) && !this.isReadOnly(component);
    }

    protected void renderARIARequired(FacesContext context, UIInput component) throws IOException {
        if (component.isRequired()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("aria-required", (Object)"true", null);
        }
    }

    protected void renderARIAInvalid(FacesContext context, UIInput component) throws IOException {
        if (!component.isValid()) {
            ResponseWriter writer = context.getResponseWriter();
            writer.writeAttribute("aria-invalid", (Object)"true", null);
        }
    }

    protected void renderAccessibilityAttributes(FacesContext context, UIInput component) throws IOException {
        this.renderAccessibilityAttributes(context, component, this.isDisabled(component), this.isReadOnly(component));
    }

    protected void renderAccessibilityAttributesHidden(FacesContext context, UIInput component) throws IOException {
        this.renderAccessibilityAttributes(context, component, this.isDisabled(component), false);
    }

    protected void renderAccessibilityAttributes(FacesContext context, UIInput component, boolean disabled, boolean readonly) throws IOException {
        InputHolder inputHolder;
        String labelledBy;
        ResponseWriter writer = context.getResponseWriter();
        this.renderARIARequired(context, component);
        this.renderARIAInvalid(context, component);
        if (component instanceof InputHolder && LangUtils.isNotBlank(labelledBy = (inputHolder = (InputHolder)component).getLabelledBy())) {
            writer.writeAttribute("aria-labelledby", (Object)labelledBy, null);
        }
        if (disabled) {
            writer.writeAttribute("disabled", (Object)"disabled", null);
        }
        if (readonly) {
            writer.writeAttribute("readonly", (Object)"readonly", null);
        }
    }

    protected void renderARIACombobox(FacesContext context, UIInput component) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.writeAttribute("role", (Object)"combobox", null);
        writer.writeAttribute("aria-haspopup", (Object)"listbox", null);
        writer.writeAttribute("aria-expanded", (Object)"false", null);
    }

    protected String createStyleClass(UIInput component, String defaultStyleClass) {
        return this.createStyleClass(component, "styleClass", defaultStyleClass);
    }

    protected String createStyleClass(UIInput component, String styleClassProperty, String defaultStyleClass) {
        String styleClass;
        StringBuilder sb = SharedStringBuilder.get(SB_STYLECLASS, 128);
        if (LangUtils.isNotBlank(defaultStyleClass)) {
            sb.append(defaultStyleClass);
        }
        if (!component.isValid()) {
            sb.append(" ui-state-error");
        }
        if (this.isDisabled(component)) {
            sb.append(" ui-state-disabled");
        }
        if (LangUtils.isNotBlank(styleClassProperty) && LangUtils.isNotBlank(styleClass = Objects.toString(component.getAttributes().get(styleClassProperty), ""))) {
            sb.append(" ").append(styleClass);
        }
        return sb.toString();
    }
}

