/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.renderkit;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import org.primefaces.context.PrimeApplicationContext;

public class RendererUtils {
    public static final String SCRIPT_TYPE = "text/javascript";
    private static final Logger LOGGER = Logger.getLogger(RendererUtils.class.getName());
    private static Method methodViewRootGetDoctype = null;
    private static Method methodDoctypeGetRootElement = null;
    private static Method methodDoctypeGetPublic = null;
    private static Method methodDoctypeGetSystem = null;

    private RendererUtils() {
    }

    public static void encodeCheckbox(FacesContext context, boolean checked) throws IOException {
        RendererUtils.encodeCheckbox(context, checked, false, false, null);
    }

    public static void encodeCheckbox(FacesContext context, boolean checked, boolean partialSelected, boolean disabled, String styleClass) throws IOException {
        Object containerClass;
        ResponseWriter writer = context.getResponseWriter();
        Object boxClass = disabled ? "ui-chkbox-box ui-widget ui-state-default ui-state-disabled" : "ui-chkbox-box ui-widget ui-state-default";
        boxClass = (String)boxClass + (checked ? " ui-state-active" : "");
        Object object = containerClass = styleClass == null ? "ui-chkbox ui-widget" : "ui-chkbox ui-widget " + styleClass;
        String icon = checked ? "ui-chkbox-icon ui-icon ui-icon-check ui-c" : (partialSelected ? "ui-chkbox-icon ui-icon ui-icon-minus ui-c" : "ui-chkbox-icon ui-icon ui-icon-blank ui-c");
        writer.startElement("div", null);
        writer.writeAttribute("class", containerClass, null);
        writer.startElement("div", null);
        writer.writeAttribute("class", boxClass, null);
        writer.startElement("span", null);
        writer.writeAttribute("class", (Object)icon, null);
        writer.endElement("span");
        writer.endElement("div");
        writer.endElement("div");
    }

    public static RenderKit getRenderKit(FacesContext context) {
        String renderKitId = null;
        UIViewRoot view = context.getViewRoot();
        if (view != null) {
            renderKitId = view.getRenderKitId();
        }
        if (renderKitId == null) {
            Application application = context.getApplication();
            ViewHandler viewHandler = application.getViewHandler();
            if (viewHandler != null) {
                renderKitId = viewHandler.calculateRenderKitId(context);
            }
            if (renderKitId == null && (renderKitId = application.getDefaultRenderKitId()) == null) {
                renderKitId = "HTML_BASIC";
            }
        }
        return ((RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory")).getRenderKit(context, renderKitId);
    }

    public static void encodeScriptTypeIfNecessary(FacesContext context) throws IOException {
        if (RendererUtils.isOutputHtml5Doctype(context)) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.writeAttribute("type", (Object)SCRIPT_TYPE, null);
    }

    public static boolean isOutputHtml5Doctype(FacesContext context) {
        PrimeApplicationContext applicationContext = PrimeApplicationContext.getCurrentInstance(context);
        String html5ComplianceSetting = applicationContext.getConfig().getHtml5Compliance();
        if ("true".equalsIgnoreCase(html5ComplianceSetting)) {
            return true;
        }
        if ("auto".equalsIgnoreCase(html5ComplianceSetting)) {
            UIViewRoot viewRoot = context.getViewRoot();
            if (viewRoot == null) {
                return false;
            }
            if (!PrimeApplicationContext.getCurrentInstance(context).getEnvironment().isAtLeastJsf40()) {
                return false;
            }
            try {
                Object doctype;
                if (methodViewRootGetDoctype == null) {
                    methodViewRootGetDoctype = viewRoot.getClass().getMethod("getDoctype", new Class[0]);
                }
                if ((doctype = methodViewRootGetDoctype.invoke((Object)viewRoot, new Object[0])) == null) {
                    return false;
                }
                if (methodDoctypeGetSystem == null) {
                    methodDoctypeGetRootElement = doctype.getClass().getMethod("getRootElement", new Class[0]);
                    methodDoctypeGetPublic = doctype.getClass().getMethod("getPublic", new Class[0]);
                    methodDoctypeGetSystem = doctype.getClass().getMethod("getSystem", new Class[0]);
                }
                String rootElement = (String)methodDoctypeGetRootElement.invoke(doctype, new Object[0]);
                String publicVal = (String)methodDoctypeGetPublic.invoke(doctype, new Object[0]);
                String system = (String)methodDoctypeGetSystem.invoke(doctype, new Object[0]);
                return "html".equalsIgnoreCase(rootElement) && publicVal == null && system == null;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Could not detect Doctype of current view!", e);
            }
        }
        return false;
    }
}

