/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Locale;
import org.primefaces.util.BigDecimalValidator;
import org.primefaces.util.Constants;

public class CurrencyValidator
extends BigDecimalValidator {
    public static final char CURRENCY_SYMBOL = '\u00a4';
    public static final String CURRENCY_SYMBOL_STR = Character.toString('\u00a4');
    private static final long serialVersionUID = -4201640771171486514L;
    private static final CurrencyValidator VALIDATOR = new CurrencyValidator();

    public static CurrencyValidator getInstance() {
        return VALIDATOR;
    }

    public BigDecimal validate(String value, Locale locale) {
        return (BigDecimal)this.parse(value, locale);
    }

    public String getExcelPattern(Locale locale) {
        DecimalFormat format = (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
        String pattern = format.toLocalizedPattern();
        pattern = pattern.replace(CURRENCY_SYMBOL_STR, "\"" + format.getDecimalFormatSymbols().getCurrencySymbol() + "\"");
        String[] patterns = pattern.split(";");
        return patterns[0];
    }

    protected Object parse(String value, Locale locale) {
        String string = value = value == null ? null : value.trim();
        if (value == null || value.isEmpty()) {
            return null;
        }
        DecimalFormat formatter = this.getFormat(locale);
        return this.parse(value, formatter);
    }

    public DecimalFormat getFormat(Locale locale) {
        return (DecimalFormat)DecimalFormat.getCurrencyInstance(locale);
    }

    @Override
    protected Number parse(String value, DecimalFormat formatter) {
        Number parsedValue;
        if (value.indexOf(164) >= 0) {
            value = value.replace(CURRENCY_SYMBOL_STR, formatter.getDecimalFormatSymbols().getCurrencySymbol());
        }
        if (formatter.getPositivePrefix().indexOf(160) >= 0) {
            value = value.replaceAll(" ", Constants.NON_BREAKING_SPACE_STR);
        }
        if ((parsedValue = super.parse(value, formatter)) != null) {
            return parsedValue;
        }
        String pattern = formatter.toPattern();
        if (pattern.indexOf(164) >= 0) {
            StringBuilder buffer = new StringBuilder(pattern.length());
            for (int i = 0; i < pattern.length(); ++i) {
                if (pattern.charAt(i) == '\u00a4') continue;
                buffer.append(pattern.charAt(i));
            }
            DecimalFormat copyFormatter = (DecimalFormat)formatter.clone();
            copyFormatter.applyPattern(buffer.toString());
            parsedValue = super.parse(value, copyFormatter);
        }
        return parsedValue;
    }
}

