/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.awt.Color;
import java.util.Locale;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.primefaces.component.export.ExcelOptions;
import org.primefaces.util.ExcelStylesManager;

public class ExcelXmlStylesManager
extends ExcelStylesManager {
    protected ExcelXmlStylesManager(Workbook wb, Locale locale, ExcelOptions options) {
        super(wb, locale, options);
    }

    @Override
    protected void applyFacetOptions(CellStyle style) {
        if (this.options != null) {
            this.applyXssfFacetOptions(style);
        }
    }

    @Override
    protected void applyCellOptions(CellStyle style) {
        if (this.options != null) {
            this.applyXssfCellOptions(style);
        }
    }

    @Override
    public RichTextString createRichTextString(String value) {
        return new XSSFRichTextString(value);
    }

    private void applyXssfFacetOptions(CellStyle style) {
        String facetFontSize;
        String facetFontColor;
        String facetBackground;
        Font facetFont = this.wb.getFontAt(style.getFontIndex());
        String facetFontStyle = this.options.getFacetFontStyle();
        if (facetFontStyle != null) {
            if ("BOLD".equalsIgnoreCase(facetFontStyle)) {
                facetFont.setBold(true);
            }
            if ("ITALIC".equalsIgnoreCase(facetFontStyle)) {
                facetFont.setItalic(true);
            }
        }
        if ((facetBackground = this.options.getFacetBgColor()) != null) {
            XSSFColor backgroundColor = new XSSFColor(Color.decode(facetBackground), (IndexedColorMap)new DefaultIndexedColorMap());
            ((XSSFCellStyle)style).setFillForegroundColor(backgroundColor);
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if ((facetFontColor = this.options.getFacetFontColor()) != null) {
            XSSFColor facetColor = new XSSFColor(Color.decode(facetFontColor), (IndexedColorMap)new DefaultIndexedColorMap());
            ((XSSFFont)facetFont).setColor(facetColor);
        }
        if ((facetFontSize = this.options.getFacetFontSize()) != null) {
            facetFont.setFontHeightInPoints(Short.parseShort(facetFontSize));
        }
    }

    private void applyXssfCellOptions(CellStyle style) {
        String cellFontStyle;
        String cellFontSize;
        Font cellFont = this.wb.getFontAt(style.getFontIndex());
        String cellFontColor = this.options.getCellFontColor();
        if (cellFontColor != null) {
            XSSFColor cellColor = new XSSFColor(Color.decode(cellFontColor), (IndexedColorMap)new DefaultIndexedColorMap());
            ((XSSFFont)cellFont).setColor(cellColor);
        }
        if ((cellFontSize = this.options.getCellFontSize()) != null) {
            cellFont.setFontHeightInPoints(Short.parseShort(cellFontSize));
        }
        if ((cellFontStyle = this.options.getCellFontStyle()) != null) {
            if ("BOLD".equalsIgnoreCase(cellFontStyle)) {
                cellFont.setBold(true);
            }
            if ("ITALIC".equalsIgnoreCase(cellFontStyle)) {
                cellFont.setItalic(true);
            }
        }
    }
}

