/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.util;

import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class LocaleUtils {
    private LocaleUtils() {
    }

    public static Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len != 2 && len != 5 && len < 7) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch0 = str.charAt(0);
        char ch1 = str.charAt(1);
        if (ch0 < 'a' || ch0 > 'z' || ch1 < 'a' || ch1 > 'z') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (len == 2) {
            return new Locale(str, "");
        }
        if (str.charAt(2) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch3 = str.charAt(3);
        if (ch3 == '_') {
            return new Locale(str.substring(0, 2), "", str.substring(4));
        }
        char ch4 = str.charAt(4);
        if (ch3 < 'A' || ch3 > 'Z' || ch4 < 'A' || ch4 > 'Z') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        if (len == 5) {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        if (str.charAt(5) != '_') {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        return new Locale(str.substring(0, 2), str.substring(3, 5), str.substring(6));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Locale resolveLocale(FacesContext context, Object locale, String clientId) {
        Locale result = null;
        if (locale == null) return context.getViewRoot().getLocale();
        if (locale instanceof String) {
            return LocaleUtils.toLocale((String)locale);
        }
        if (!(locale instanceof Locale)) throw new IllegalArgumentException("Type:" + String.valueOf(locale.getClass()) + " is not a valid locale type for: " + clientId);
        return (Locale)locale;
    }

    public static String toJavascriptLocale(Locale locale) {
        return locale.toString().toLowerCase().replace('_', '-');
    }

    public static Locale getCurrentLocale(FacesContext context) {
        Locale locale = null;
        if (context != null) {
            UIViewRoot viewRoot = context.getViewRoot();
            if (viewRoot != null) {
                locale = viewRoot.getLocale();
            }
            if (locale == null) {
                locale = context.getExternalContext().getRequestLocale();
            }
            if (locale == null) {
                locale = context.getApplication().getDefaultLocale();
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static Locale getCurrentLocale() {
        return LocaleUtils.getCurrentLocale(FacesContext.getCurrentInstance());
    }

    public static String getDecimalSeparator(FacesContext context) {
        Locale locale = LocaleUtils.getCurrentLocale(context);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        return Character.toString(decimalFormatSymbols.getDecimalSeparator());
    }

    public static String getThousandSeparator(FacesContext context) {
        Locale locale = LocaleUtils.getCurrentLocale(context);
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(locale);
        return Character.toString(decimalFormatSymbols.getGroupingSeparator());
    }

    public static String getCurrentLanguage() {
        return LocaleUtils.calculateLanguage(LocaleUtils.getCurrentLocale());
    }

    public static String calculateLanguage(Locale locale) {
        return locale.getLanguage();
    }
}

