/*
 * Decompiled with CFR 0.152.
 */
package net.oauth;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthServiceProvider;

public class ConsumerProperties {
    private final Properties consumerProperties;
    private final Map<String, OAuthConsumer> pool = new HashMap<String, OAuthConsumer>();

    public static URL getResource(String name, ClassLoader loader) throws IOException {
        URL resource = loader.getResource(name);
        if (resource == null) {
            throw new IOException("resource not found: " + name);
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(URL source) throws IOException {
        try (InputStream input = source.openStream();){
            Properties p = new Properties();
            p.load(input);
            Properties properties = p;
            return properties;
        }
    }

    public ConsumerProperties(String resourceName, ClassLoader loader) throws IOException {
        this(ConsumerProperties.getProperties(ConsumerProperties.getResource(resourceName, loader)));
    }

    public ConsumerProperties(Properties consumerProperties) {
        this.consumerProperties = consumerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OAuthConsumer getConsumer(String name) throws MalformedURLException {
        OAuthConsumer consumer;
        Map<String, OAuthConsumer> map = this.pool;
        synchronized (map) {
            consumer = this.pool.get(name);
        }
        if (consumer == null) {
            consumer = this.newConsumer(name);
        }
        map = this.pool;
        synchronized (map) {
            OAuthConsumer first = this.pool.get(name);
            if (first == null) {
                this.pool.put(name, consumer);
            } else {
                consumer = first;
            }
        }
        return consumer;
    }

    protected OAuthConsumer newConsumer(String name) throws MalformedURLException {
        String base = this.consumerProperties.getProperty(name + ".serviceProvider.baseURL");
        URL baseURL = base == null ? null : new URL(base);
        OAuthServiceProvider serviceProvider = new OAuthServiceProvider(this.getURL(baseURL, name + ".serviceProvider.requestTokenURL"), this.getURL(baseURL, name + ".serviceProvider.userAuthorizationURL"), this.getURL(baseURL, name + ".serviceProvider.accessTokenURL"));
        OAuthConsumer consumer = new OAuthConsumer(this.consumerProperties.getProperty(name + ".callbackURL"), this.consumerProperties.getProperty(name + ".consumerKey"), this.consumerProperties.getProperty(name + ".consumerSecret"), serviceProvider);
        consumer.setProperty("name", name);
        if (baseURL != null) {
            consumer.setProperty("serviceProvider.baseURL", baseURL);
        }
        for (Map.Entry<Object, Object> prop : this.consumerProperties.entrySet()) {
            String propName = (String)prop.getKey();
            if (!propName.startsWith(name + ".consumer.")) continue;
            String c = propName.substring(name.length() + 10);
            consumer.setProperty(c, prop.getValue());
        }
        return consumer;
    }

    private String getURL(URL base, String name) throws MalformedURLException {
        String url = this.consumerProperties.getProperty(name);
        if (base != null) {
            url = new URL(base, url).toExternalForm();
        }
        return url;
    }
}

