/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.http;

import java.util.Enumeration;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    public static void printHeaders(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        System.out.println("Headers for " + request.getRequestURI());
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            System.out.println("Header Name - " + headerName + ", Value - " + request.getHeader(headerName));
        }
    }

    public static void printParameters(HttpServletRequest request) {
        System.out.println("Parameters for " + request.getRequestURI());
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String paramName = (String)params.nextElement();
            System.out.println("Parameter Name - " + paramName + ", Value - " + request.getParameter(paramName));
        }
    }

    public static String getCookie(HttpServletRequest request, String lookup) {
        if (request == null || lookup == null) {
            return null;
        }
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            String cookieName = cookie.getName();
            String cookieValue = cookie.getValue();
            if (StringUtils.isEmpty((CharSequence)cookieName) || !cookieName.equalsIgnoreCase(lookup)) continue;
            return cookieValue;
        }
        return null;
    }
}

