/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.lti13;

import java.io.IOException;
import java.io.PrintWriter;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletResponse;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.jackson.JacksonUtil;
import org.tsugi.lti13.objects.LTI11Transition;
import org.tsugi.lti13.objects.LaunchJWT;

public class LTI13Util {
    private static final Logger log = LoggerFactory.getLogger(LTI13Util.class);

    public static Map<String, String> generateKeys() throws NoSuchAlgorithmException {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        KeyPair kp = keyGen.genKeyPair();
        byte[] publicKey = kp.getPublic().getEncoded();
        byte[] privateKey = kp.getPrivate().getEncoded();
        Base64.Encoder encoder = Base64.getEncoder();
        String publicRSA = "-----BEGIN PUBLIC KEY-----\n" + encoder.encodeToString(privateKey) + "\n-----END PUBLIC KEY-----\n";
        String privateRSA = "-----BEGIN PRIVATE KEY-----\n" + encoder.encodeToString(privateKey) + "\n-----END PRIVATE KEY-----\n";
        TreeMap<String, String> returnMap = new TreeMap<String, String>();
        returnMap.put("platform_public", publicRSA);
        returnMap.put("platform_private", privateRSA);
        keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048);
        kp = keyGen.genKeyPair();
        publicKey = kp.getPublic().getEncoded();
        privateKey = kp.getPrivate().getEncoded();
        publicRSA = "-----BEGIN RSA PUBLIC KEY-----\n" + encoder.encodeToString(privateKey) + "\n-----END RSA PUBLIC KEY-----\n";
        privateRSA = "-----BEGIN RSA PRIVATE KEY-----\n" + encoder.encodeToString(privateKey) + "\n-----END RSA PRIVATE KEY-----\n";
        returnMap.put("tool_public", publicRSA);
        returnMap.put("tool_private", privateRSA);
        return returnMap;
    }

    public static String stripPKCS8(String input) {
        if (input == null) {
            return input;
        }
        if (!input.startsWith("-----BEGIN")) {
            return input;
        }
        String[] lines = input.split("\n");
        String retval = "";
        for (String line : lines) {
            if (line.startsWith("----")) continue;
            retval = retval + line.trim();
        }
        return retval;
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048);
            KeyPair kp = keyGen.genKeyPair();
            return kp;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getPublicEncoded(KeyPair kp) {
        return LTI13Util.getPublicEncoded(kp.getPublic());
    }

    public static String getPublicEncoded(Key key) {
        byte[] encodeArray = key.getEncoded();
        Base64.Encoder encoder = Base64.getEncoder();
        String publicRSA = "-----BEGIN PUBLIC KEY-----\n" + LTI13Util.breakKeyIntoLines(encoder.encodeToString(encodeArray)) + "\n-----END PUBLIC KEY-----\n";
        return publicRSA;
    }

    public static String getPrivateEncoded(KeyPair kp) {
        return LTI13Util.getPrivateEncoded(kp.getPrivate());
    }

    public static String getPrivateEncoded(Key key) {
        byte[] encodeArray = key.getEncoded();
        Base64.Encoder encoder = Base64.getEncoder();
        String privateRSA = "-----BEGIN PRIVATE KEY-----\n" + LTI13Util.breakKeyIntoLines(encoder.encodeToString(encodeArray)) + "\n-----END PRIVATE KEY-----\n";
        return privateRSA;
    }

    public static String breakKeyIntoLines(String rawkey) {
        int len = 65;
        StringBuilder ret = new StringBuilder();
        String trimmed = rawkey.trim();
        for (int i = 0; i < trimmed.length(); i += len) {
            int end = i + len;
            if (ret.length() > 0) {
                ret.append("\n");
            }
            if (end > trimmed.length()) {
                end = trimmed.length();
            }
            ret.append(trimmed.substring(i, end));
        }
        return ret.toString();
    }

    public static Key string2PrivateKey(String keyString) {
        if (keyString == null) {
            return null;
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            keyString = LTI13Util.stripPKCS8(keyString);
            PKCS8EncodedKeySpec keySpecPKCS8 = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(keyString.getBytes()));
            return kf.generatePrivate(keySpecPKCS8);
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static Key string2PublicKey(String keyString) {
        if (keyString == null) {
            return null;
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            keyString = LTI13Util.stripPKCS8(keyString);
            X509EncodedKeySpec keySpecX509 = new X509EncodedKeySpec(Base64.getDecoder().decode(keyString));
            return kf.generatePublic(keySpecX509);
        }
        catch (IllegalArgumentException | InvalidKeySpecException e) {
            return null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getLTI11TransitionBase(LaunchJWT lj) {
        String nonce = lj.nonce;
        Long expires = lj.expires;
        String issuer = lj.issuer;
        String client_id = lj.audience;
        String subject = lj.subject;
        String deployment_id = lj.deployment_id;
        if (nonce == null || issuer == null || expires == null || client_id == null || subject == null || deployment_id == null) {
            return null;
        }
        if (lj.lti11_transition == null) {
            return null;
        }
        LTI11Transition lti11_transition = lj.lti11_transition;
        String user_id = lti11_transition.user_id;
        String oauth_consumer_key = lti11_transition.oauth_consumer_key;
        if (user_id == null || oauth_consumer_key == null) {
            return null;
        }
        String base = oauth_consumer_key + "&" + deployment_id + "&" + issuer + "&" + client_id + "&" + expires + "&" + nonce;
        return base;
    }

    public static String signLTI11Transition(LaunchJWT lj, String secret) {
        if (secret == null) {
            return null;
        }
        String base = LTI13Util.getLTI11TransitionBase(lj);
        if (base == null) {
            return null;
        }
        String signature = LTI13Util.compute_HMAC_SHA256(base, secret);
        return signature;
    }

    public static boolean checkLTI11Transition(LaunchJWT lj, String key, String secret) {
        if (key == null) {
            return false;
        }
        if (secret == null) {
            return false;
        }
        LTI11Transition lti11_transition = lj.lti11_transition;
        if (lti11_transition == null) {
            return false;
        }
        String oauth_consumer_key_sign = lti11_transition.oauth_consumer_key_sign;
        if (oauth_consumer_key_sign == null) {
            return false;
        }
        String oauth_consumer_key = lti11_transition.oauth_consumer_key;
        if (oauth_consumer_key == null) {
            return false;
        }
        if (!oauth_consumer_key.equals(key)) {
            return false;
        }
        String base = LTI13Util.getLTI11TransitionBase(lj);
        if (base == null) {
            return false;
        }
        String signature = LTI13Util.compute_HMAC_SHA256(base, secret);
        return oauth_consumer_key_sign.equals(signature);
    }

    public static String sha256(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            String hash = Base64.getEncoder().encodeToString(md.digest(input.getBytes()));
            return hash;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String compute_HMAC_SHA256(String message, String secret) {
        try {
            Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret_key = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256_HMAC.init(secret_key);
            String hash = Base64.getEncoder().encodeToString(sha256_HMAC.doFinal(message.getBytes()));
            return hash;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void return400(HttpServletResponse response, String error, String detail) {
        response.setContentType("application/json;charset=UTF-8");
        response.setHeader("Cache-Control", "no-store");
        response.setStatus(400);
        if (detail != null) {
            response.setHeader("X-Tsugi-LTI13-Error-Detail", detail);
        }
        JSONObject job = new JSONObject();
        job.put((Object)"error", (Object)error);
        String retval = JacksonUtil.toString(job);
        try {
            PrintWriter out = response.getWriter();
            out.println(retval);
        }
        catch (IOException e) {
            response.setStatus(400);
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void return400(HttpServletResponse response, String error) {
        LTI13Util.return400(response, error, null);
    }
}

