/*
 * Decompiled with CFR 0.152.
 */
package org.tsugi.pox;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.SimpleOAuthValidator;
import net.oauth.server.OAuthServlet;
import net.oauth.signature.OAuthSignatureMethod;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tsugi.basiclti.Base64;
import org.tsugi.basiclti.XMLMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IMSPOXRequest {
    private static final Logger log = LoggerFactory.getLogger(IMSPOXRequest.class);
    public static final String MAJOR_SUCCESS = "success";
    public static final String MAJOR_FAILURE = "failure";
    public static final String MAJOR_UNSUPPORTED = "unsupported";
    public static final String MAJOR_PROCESSING = "processing";
    public static final String[] validMajor = new String[]{"success", "failure", "unsupported", "processing"};
    public static final String SEVERITY_ERROR = "error";
    public static final String SEVERITY_WARNING = "warning";
    public static final String SEVERITY_STATUS = "status";
    public static final String[] validSeverity = new String[]{"error", "warning", "status"};
    public static final String MINOR_FULLSUCCESS = "fullsuccess";
    public static final String MINOR_NOSOURCEDIDS = "nosourcedids";
    public static final String MINOR_IDALLOC = "idalloc";
    public static final String MINOR_OVERFLOWFAIL = "overflowfail";
    public static final String MINOR_IDALLOCINUSEFAIL = "idallocinusefail";
    public static final String MINOR_INVALIDDATAFAIL = "invaliddata";
    public static final String MINOR_INCOMPLETEDATA = "incompletedata";
    public static final String MINOR_PARTIALSTORAGE = "partialdatastorage";
    public static final String MINOR_UNKNOWNOBJECT = "unknownobject";
    public static final String MINOR_DELETEFAILURE = "deletefailure";
    public static final String MINOR_TARGETREADFAILURE = "targetreadfailure";
    public static final String MINOR_SAVEPOINTERROR = "savepointerror";
    public static final String MINOR_SAVEPOINTSYNCERROR = "savepointsyncerror";
    public static final String MINOR_UNKNOWNQUERY = "unknownquery";
    public static final String MINOR_UNKNOWNVOCAB = "unknownvocab";
    public static final String MINOR_TARGETISBUSY = "targetisbusy";
    public static final String MINOR_UNKNOWNEXTENSION = "unknownextension";
    public static final String MINOR_UNAUTHORIZEDREQUEST = "unauthorizedrequest";
    public static final String MINOR_LINKFAILURE = "linkfailure";
    public static final String MINOR_UNSUPPORTED = "unsupported";
    public static final String[] validMinor = new String[]{"fullsuccess", "nosourcedids", "idalloc", "overflowfail", "idallocinusefail", "invaliddata", "incompletedata", "partialdatastorage", "unknownobject", "deletefailure", "targetreadfailure", "savepointerror", "savepointsyncerror", "unknownquery", "unknownvocab", "targetisbusy", "unknownextension", "unauthorizedrequest", "linkfailure", "unsupported"};
    public Document postDom = null;
    public Element bodyElement = null;
    public Element headerElement = null;
    public String postBody = null;
    private String header = null;
    private String oauth_body_hash = null;
    private String oauth_consumer_key = null;
    private String oauth_signature_method = null;
    public boolean valid = false;
    private String operation = null;
    public String errorMessage = null;
    public String base_string = null;
    private Map<String, String> bodyMap = null;
    private Map<String, String> headerMap = null;
    static final String fatalMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<imsx_POXEnvelopeResponse xmlns = \"http://www.imsglobal.org/services/ltiv1p1/xsd/imsoms_v1p0\">\n    <imsx_POXHeader>\n        <imsx_POXResponseHeaderInfo>\n            <imsx_version>V1.0</imsx_version>\n            <imsx_messageIdentifier>%s</imsx_messageIdentifier>\n            <imsx_statusInfo>\n                <imsx_codeMajor>failure</imsx_codeMajor>\n                <imsx_severity>error</imsx_severity>\n                <imsx_description>%s</imsx_description>\n                <imsx_operationRefIdentifier>%s</imsx_operationRefIdentifier>            </imsx_statusInfo>\n        </imsx_POXResponseHeaderInfo>\n    </imsx_POXHeader>\n    <imsx_POXBody/>\n</imsx_POXEnvelopeResponse>";
    static final String responseMessage = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<imsx_POXEnvelopeResponse xmlns = \"http://www.imsglobal.org/services/ltiv1p1/xsd/imsoms_v1p0\">\n  <imsx_POXHeader>\n    <imsx_POXResponseHeaderInfo>\n      <imsx_version>V1.0</imsx_version>\n      <imsx_messageIdentifier>%s</imsx_messageIdentifier>\n      <imsx_statusInfo>\n        <imsx_codeMajor>%s</imsx_codeMajor>\n        <imsx_severity>%s</imsx_severity>\n        <imsx_description>%s</imsx_description>\n        <imsx_messageRefIdentifier>%s</imsx_messageRefIdentifier>\n        <imsx_operationRefIdentifier>%s</imsx_operationRefIdentifier>%s\n      </imsx_statusInfo>\n    </imsx_POXResponseHeaderInfo>\n  </imsx_POXHeader>\n  <imsx_POXBody>\n%s%s  </imsx_POXBody>\n</imsx_POXEnvelopeResponse>";
    static final String inputTestData = "<?xml version = \"1.0\" encoding = \"UTF-8\"?>\n<imsx_POXEnvelopeRequest xmlns = \"http://www.imsglobal.org/services/ltiv1p1/xsd/imsoms_v1p0\">\n<imsx_POXHeader>\n<imsx_POXRequestHeaderInfo>\n<imsx_version>V1.0</imsx_version>\n<imsx_messageIdentifier>999999123</imsx_messageIdentifier>\n</imsx_POXRequestHeaderInfo>\n</imsx_POXHeader>\n<imsx_POXBody>\n<replaceResultRequest>\n<resultRecord>\n<sourcedGUID>\n<sourcedId>3124567</sourcedId>\n</sourcedGUID>\n<result>\n<resultScore>\n<language>en-us</language>\n<textString>A</textString>\n</resultScore>\n</result>\n</resultRecord>\n</replaceResultRequest>\n</imsx_POXBody>\n</imsx_POXEnvelopeRequest>";

    public String getOperation() {
        return this.operation;
    }

    public String getOAuthConsumerKey() {
        return this.oauth_consumer_key;
    }

    public String getHeaderVersion() {
        return this.getHeaderItem("/imsx_version");
    }

    public String getHeaderMessageIdentifier() {
        return this.getHeaderItem("/imsx_messageIdentifier");
    }

    public String getHeaderItem(String path) {
        if (this.getHeaderMap() == null) {
            return null;
        }
        return this.headerMap.get(path);
    }

    public Map<String, String> getHeaderMap() {
        if (this.headerMap != null) {
            return this.headerMap;
        }
        if (this.headerElement == null) {
            return null;
        }
        this.headerMap = XMLMap.getMap(this.headerElement);
        return this.headerMap;
    }

    public Map<String, String> getBodyMap() {
        if (this.bodyMap != null) {
            return this.bodyMap;
        }
        if (this.bodyElement == null) {
            return null;
        }
        this.bodyMap = XMLMap.getMap(this.bodyElement);
        return this.bodyMap;
    }

    public String getPostBody() {
        return this.postBody;
    }

    public IMSPOXRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request) {
        this.loadFromRequest(request);
        if (!this.valid) {
            return;
        }
        this.validateRequest(oauth_consumer_key, oauth_secret, request);
    }

    public IMSPOXRequest(HttpServletRequest request) {
        this.loadFromRequest(request);
    }

    public IMSPOXRequest(String bodyString) {
        this.postBody = bodyString;
        this.parsePostBody();
    }

    public void loadFromRequest(HttpServletRequest request) {
        String baseContentType;
        String contentType = request.getContentType();
        try {
            MimeType mimeType = new MimeType(contentType);
            baseContentType = mimeType.getBaseType();
        }
        catch (MimeTypeParseException e) {
            this.errorMessage = "Unable to parse mime type";
            log.info("{}\n{}", (Object)this.errorMessage, (Object)contentType);
            return;
        }
        if (!"application/xml".equals(baseContentType)) {
            this.errorMessage = "Content Type must be application/xml";
            log.info("{}\n{}", (Object)this.errorMessage, (Object)contentType);
            return;
        }
        this.header = request.getHeader("Authorization");
        this.oauth_body_hash = null;
        if (this.header != null) {
            String[] parms;
            if (this.header.startsWith("OAuth ")) {
                this.header = this.header.substring(5);
            }
            for (String parm : parms = this.header.split(",")) {
                String[] pieces;
                if ((parm = parm.trim()).startsWith("oauth_body_hash=")) {
                    pieces = parm.split("\"");
                    this.oauth_body_hash = URLDecoder.decode(pieces[1]);
                }
                if (parm.startsWith("oauth_consumer_key=")) {
                    pieces = parm.split("\"");
                    this.oauth_consumer_key = URLDecoder.decode(pieces[1]);
                }
                if (!parm.startsWith("oauth_signature_method=")) continue;
                pieces = parm.split("\"");
                this.oauth_signature_method = URLDecoder.decode(pieces[1]);
            }
        }
        if (this.oauth_body_hash == null) {
            this.errorMessage = "Did not find oauth_body_hash";
            log.info("{}\n{}", (Object)this.errorMessage, (Object)this.header);
            return;
        }
        log.debug("OBH={}", (Object)this.oauth_body_hash);
        log.debug("OSM={}", (Object)this.oauth_signature_method);
        char[] buffer = new char[65536];
        try {
            int read;
            StringBuilder out = new StringBuilder();
            BufferedReader in = request.getReader();
            do {
                if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
                out.append(buffer, 0, read);
            } while (read >= 0);
            this.postBody = out.toString();
        }
        catch (Exception e) {
            this.errorMessage = "Could not read message body:" + e.getMessage();
            return;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            if ("HMAC-SHA256".equals(this.oauth_signature_method)) {
                md = MessageDigest.getInstance("SHA-256");
            }
            md.update(this.postBody.getBytes());
            byte[] output = Base64.encode(md.digest());
            String hash = new String(output);
            log.debug("HASH={}", (Object)hash);
            if (!hash.equals(this.oauth_body_hash)) {
                this.errorMessage = "Body hash does not match header";
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = "Could not compute body hash";
            return;
        }
        this.parsePostBody();
    }

    public void parsePostBody() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.postDom = db.parse(new ByteArrayInputStream(this.postBody.getBytes()));
        }
        catch (Exception e) {
            this.errorMessage = "Could not parse XML: " + e.getMessage();
            return;
        }
        try {
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile("/imsx_POXEnvelopeRequest/imsx_POXBody/*");
            Object result = expr.evaluate(this.postDom, XPathConstants.NODESET);
            NodeList nodes = (NodeList)result;
            this.bodyElement = (Element)nodes.item(0);
            this.operation = this.bodyElement.getNodeName();
            expr = xpath.compile("/imsx_POXEnvelopeRequest/imsx_POXHeader/*");
            result = expr.evaluate(this.postDom, XPathConstants.NODESET);
            nodes = (NodeList)result;
            this.headerElement = (Element)nodes.item(0);
        }
        catch (XPathExpressionException e) {
            this.errorMessage = "Could not parse XPATH: " + e.getMessage();
            return;
        }
        catch (Exception e) {
            this.errorMessage = "Could not parse input XML: " + e.getMessage();
            return;
        }
        if (this.operation == null || this.bodyElement == null) {
            this.errorMessage = "Could not find operation";
            return;
        }
        this.valid = true;
    }

    public void validateRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request) {
        this.validateRequest(oauth_consumer_key, oauth_secret, request, null);
    }

    public void validateRequest(String oauth_consumer_key, String oauth_secret, HttpServletRequest request, String URL2) {
        this.valid = false;
        OAuthMessage oam = OAuthServlet.getMessage(request, URL2);
        SimpleOAuthValidator oav = new SimpleOAuthValidator();
        OAuthConsumer cons = new OAuthConsumer("about:blank#OAuth+CallBack+NotUsed", oauth_consumer_key, oauth_secret, null);
        OAuthAccessor acc = new OAuthAccessor(cons);
        try {
            this.base_string = OAuthSignatureMethod.getBaseString(oam);
            log.debug("POX base_string={}", (Object)this.base_string);
        }
        catch (Exception e) {
            this.base_string = null;
        }
        try {
            oav.validateMessage(oam, acc);
        }
        catch (Exception e) {
            this.errorMessage = "Launch fails OAuth validation: " + e.getMessage();
            return;
        }
        this.valid = true;
    }

    public static String fetchTag(Element element, String tag) {
        try {
            Element e;
            NodeList elements = element.getElementsByTagName(tag);
            int numElements = elements.getLength();
            if (numElements > 0 && (e = (Element)elements.item(0)).hasChildNodes()) {
                return e.getFirstChild().getNodeValue();
            }
        }
        catch (Throwable t) {
            log.warn(t.getMessage(), t);
        }
        return null;
    }

    public boolean inArray(String[] theArray, String theString) {
        if (theString == null) {
            return false;
        }
        for (String str : theArray) {
            if (!theString.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static String getFatalResponse(String description) {
        return IMSPOXRequest.getFatalResponse(description, "unknown");
    }

    public static String getFatalResponse(String description, String message_id) {
        Date dt = new Date();
        String messageId = "" + dt.getTime();
        return String.format(fatalMessage, StringEscapeUtils.escapeXml11((String)messageId), StringEscapeUtils.escapeXml11((String)description), StringEscapeUtils.escapeXml11((String)message_id));
    }

    public String getResponseUnsupported(String desc) {
        return this.getResponse(desc, "unsupported", null, null, null, null);
    }

    public String getResponseFailure(String desc, Properties minor) {
        return this.getResponse(desc, null, null, null, minor, null);
    }

    public String getResponseFailure(String desc, Properties minor, String bodyString) {
        return this.getResponse(desc, null, null, null, minor, bodyString);
    }

    public String getResponseSuccess(String desc, String bodyString) {
        return this.getResponse(desc, MAJOR_SUCCESS, null, null, null, bodyString);
    }

    public String getResponse(String description, String major, String severity, String messageId, Properties minor, String bodyString) {
        int pos;
        StringBuffer internalError = new StringBuffer();
        if (major == null) {
            major = MAJOR_FAILURE;
        }
        if (severity == null && MAJOR_PROCESSING.equals(major)) {
            severity = SEVERITY_STATUS;
        }
        if (severity == null && MAJOR_SUCCESS.equals(major)) {
            severity = SEVERITY_STATUS;
        }
        if (severity == null) {
            severity = SEVERITY_ERROR;
        }
        if (messageId == null) {
            Date dt = new Date();
            messageId = "" + dt.getTime();
        }
        StringBuffer sb = new StringBuffer();
        if (minor != null && minor.size() > 0) {
            for (Object okey : minor.keySet()) {
                String key = (String)okey;
                String value = minor.getProperty(key);
                if (key == null || value == null) continue;
                if (!this.inArray(validMinor, value)) {
                    if (internalError.length() > 0) {
                        sb.append(", ");
                    }
                    internalError.append("Invalid imsx_codeMinorFieldValue=" + major);
                    continue;
                }
                if (sb.length() == 0) {
                    sb.append("\n        <imsx_codeMinor>\n");
                }
                sb.append("          <imsx_codeMinorField>\n            <imsx_codeMinorFieldName>");
                sb.append(key);
                sb.append("</imsx_codeMinorFieldName>\n            <imsx_codeMinorFieldValue>");
                sb.append(StringEscapeUtils.escapeXml11((String)value));
                sb.append("</imsx_codeMinorFieldValue>\n          </imsx_codeMinorField>\n");
            }
            if (sb.length() > 0) {
                sb.append("        </imsx_codeMinor>");
            }
        }
        String minorString = sb.toString();
        if (!this.inArray(validMajor, major)) {
            if (internalError.length() > 0) {
                sb.append(", ");
            }
            internalError.append("Invalid imsx_codeMajor=" + major);
        }
        if (!this.inArray(validSeverity, severity)) {
            if (internalError.length() > 0) {
                sb.append(", ");
            }
            internalError.append("Invalid imsx_severity=" + major);
        }
        if (internalError.length() > 0) {
            description = description + " (Internal error: " + internalError.toString() + ")";
            log.warn(internalError.toString());
        }
        if (bodyString == null) {
            bodyString = "";
        }
        if (bodyString.startsWith("<?xml") && (pos = bodyString.indexOf("<", 1)) > 0) {
            bodyString = bodyString.substring(pos);
        }
        bodyString = bodyString.trim();
        String newLine = "";
        if (bodyString.length() > 0) {
            newLine = "\n";
        }
        return String.format(responseMessage, StringEscapeUtils.escapeXml11((String)messageId), StringEscapeUtils.escapeXml11((String)major), StringEscapeUtils.escapeXml11((String)severity), StringEscapeUtils.escapeXml11((String)description), StringEscapeUtils.escapeXml11((String)this.getHeaderMessageIdentifier()), StringEscapeUtils.escapeXml11((String)this.operation), StringEscapeUtils.escapeXml11((String)minorString), bodyString, newLine);
    }

    public static void runTest() {
        log.debug("Runnig test.");
        IMSPOXRequest pox = new IMSPOXRequest(inputTestData);
        log.debug("Version = {}", (Object)pox.getHeaderVersion());
        log.debug("Operation = {}", (Object)pox.getOperation());
        Map<String, String> bodyMap = pox.getBodyMap();
        String guid = bodyMap.get("/resultRecord/sourcedGUID/sourcedId");
        log.debug("guid={}", (Object)guid);
        String grade = bodyMap.get("/resultRecord/result/resultScore/textString");
        log.debug("grade={}", (Object)grade);
        String desc = "Message received and validated operation=" + pox.getOperation() + " guid=" + guid + " grade=" + grade;
        String output = pox.getResponseUnsupported(desc);
        log.debug("---- Unsupported ----");
        log.debug(output);
        Properties props = new Properties();
        props.setProperty("fred", "zap");
        props.setProperty("sam", MINOR_IDALLOC);
        log.debug("---- Generate logger Error ----");
        output = pox.getResponseFailure(desc, props);
        log.debug("---- Failure ----");
        log.debug(output);
        TreeMap<String, Object> theMap = new TreeMap<String, Object>();
        theMap.put("/readMembershipResponse/membershipRecord/sourcedId", "123course456");
        ArrayList lm = new ArrayList();
        TreeMap<String, String> mm = new TreeMap<String, String>();
        mm.put("/personSourcedId", "123user456");
        mm.put("/role/roleType", "Learner");
        lm.add(mm);
        mm = new TreeMap();
        mm.put("/personSourcedId", "789user123");
        mm.put("/role/roleType", "Instructor");
        lm.add(mm);
        theMap.put("/readMembershipResponse/membershipRecord/membership/member", lm);
        String theXml = XMLMap.getXMLFragment(theMap, true);
        log.debug("th={}", (Object)theXml);
        output = pox.getResponseSuccess(desc, theXml);
        log.debug("---- Success String ----");
        log.debug(output);
    }
}

