/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springdoc.core.SpringDocAnnotationsUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.method.HandlerMethod;

@Component
public abstract class AbstractResponseBuilder {
    private Map<String, ApiResponse> genericMapResponse = new HashMap<String, ApiResponse>();

    public io.swagger.v3.oas.models.responses.ApiResponses build(Components components, HandlerMethod handlerMethod, Operation operation, String[] methodProduces) {
        io.swagger.v3.oas.models.responses.ApiResponses apiResponses = operation.getResponses();
        if (apiResponses == null) {
            apiResponses = new io.swagger.v3.oas.models.responses.ApiResponses();
        }
        for (Map.Entry<String, ApiResponse> entry : this.genericMapResponse.entrySet()) {
            apiResponses.addApiResponse(entry.getKey(), entry.getValue());
        }
        this.computeResponse(components, handlerMethod.getMethod(), apiResponses, methodProduces, false);
        return apiResponses;
    }

    public void buildGenericResponse(Components components, Map<String, Object> findControllerAdvice) {
        List<Method> methods = this.getMethods(findControllerAdvice);
        for (Method method : methods) {
            RequestMapping reqMappringMethod = (RequestMapping)ReflectionUtils.getAnnotation((Method)method, RequestMapping.class);
            String[] methodProduces = null;
            if (reqMappringMethod != null) {
                methodProduces = reqMappringMethod.produces();
            }
            Map<String, ApiResponse> apiResponses = this.computeResponse(components, method, new io.swagger.v3.oas.models.responses.ApiResponses(), methodProduces, true);
            for (Map.Entry<String, ApiResponse> entry : apiResponses.entrySet()) {
                this.genericMapResponse.put(entry.getKey(), entry.getValue());
            }
        }
    }

    private List<Method> getMethods(Map<String, Object> findControllerAdvice) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Map.Entry<String, Object> entry : findControllerAdvice.entrySet()) {
            Object controllerAdvice = entry.getValue();
            Class objClz = controllerAdvice.getClass();
            if (AopUtils.isAopProxy((Object)controllerAdvice)) {
                objClz = AopUtils.getTargetClass((Object)controllerAdvice);
            }
            for (Method m : objClz.getDeclaredMethods()) {
                if (!m.isAnnotationPresent(ExceptionHandler.class)) continue;
                methods.add(m);
            }
        }
        return methods;
    }

    private Map<String, ApiResponse> computeResponse(Components components, Method method, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, String[] methodProduces, boolean isGeneric) {
        Object[] responsesArray = this.getApiResponses(method);
        if (ArrayUtils.isNotEmpty((Object[])responsesArray)) {
            for (Object apiResponse2 : responsesArray) {
                ApiResponse apiResponse1 = new ApiResponse();
                apiResponse1.setDescription(apiResponse2.description());
                io.swagger.v3.oas.annotations.media.Content[] contentdoc = apiResponse2.content();
                SpringDocAnnotationsUtils.getContent(contentdoc, new String[]{}, methodProduces == null ? new String[]{} : methodProduces, null, components, null).ifPresent(arg_0 -> ((ApiResponse)apiResponse1).content(arg_0));
                apiResponsesOp.addApiResponse(apiResponse2.responseCode(), apiResponse1);
            }
        }
        if (!CollectionUtils.isEmpty((Map)apiResponsesOp) && apiResponsesOp.size() != this.genericMapResponse.size()) {
            for (Map.Entry entry : apiResponsesOp.entrySet()) {
                String httpCode = (String)entry.getKey();
                ApiResponse apiResponse = (ApiResponse)entry.getValue();
                this.buildApiResponses(components, method, apiResponsesOp, methodProduces, httpCode, apiResponse);
            }
        } else {
            String httpCode = this.evaluateResponseStatus(method, method.getClass(), isGeneric);
            if (httpCode != null) {
                this.buildApiResponses(components, method, apiResponsesOp, methodProduces, httpCode, new ApiResponse());
            }
        }
        return apiResponsesOp;
    }

    private io.swagger.v3.oas.annotations.responses.ApiResponse[] getApiResponses(Method method) {
        io.swagger.v3.oas.annotations.responses.ApiResponse[] responsesArray = null;
        ApiResponses apiResponsesDoc = (ApiResponses)ReflectionUtils.getAnnotation((Method)method, ApiResponses.class);
        if (apiResponsesDoc != null) {
            responsesArray = apiResponsesDoc.value();
        } else {
            List apiResponseDoc = ReflectionUtils.getRepeatableAnnotations((Method)method, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
            if (!CollectionUtils.isEmpty((Collection)apiResponseDoc)) {
                responsesArray = (io.swagger.v3.oas.annotations.responses.ApiResponse[])apiResponseDoc.stream().toArray(io.swagger.v3.oas.annotations.responses.ApiResponse[]::new);
            }
        }
        return responsesArray;
    }

    protected abstract Content buildContent(Components var1, Method var2, String[] var3);

    protected Schema calculateSchemaParameterizedType(Components components, ParameterizedType parameterizedType) {
        Schema schemaN = null;
        if (parameterizedType.getActualTypeArguments()[0] instanceof Class && !Void.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
            schemaN = this.calculateSchema(components, parameterizedType);
        } else if (parameterizedType.getActualTypeArguments()[0] instanceof ParameterizedType && !Void.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
            parameterizedType = (ParameterizedType)parameterizedType.getActualTypeArguments()[0];
            schemaN = this.calculateSchemaForActualTypeArguments(components, parameterizedType);
        } else if (Void.class.equals((Object)parameterizedType.getActualTypeArguments()[0])) {
            schemaN = AnnotationsUtils.resolveSchemaFromType(String.class, null, null);
        }
        return schemaN;
    }

    protected void setContent(String[] methodProduces, Content content, MediaType mediaType) {
        if (ArrayUtils.isNotEmpty((Object[])methodProduces)) {
            for (String mediaTypeStr : methodProduces) {
                content.addMediaType(mediaTypeStr, mediaType);
            }
        } else if (content.size() == 0) {
            content.addMediaType("*/*", mediaType);
        }
    }

    protected Schema extractSchema(Components components, Type returnType) {
        Schema schemaN = null;
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true));
        if (resolvedSchema.schema != null) {
            schemaN = resolvedSchema.schema;
            Map schemaMap = resolvedSchema.referencedSchemas;
            if (schemaMap != null) {
                schemaMap.forEach((arg_0, arg_1) -> ((Components)components).addSchemas(arg_0, arg_1));
            }
        }
        return schemaN;
    }

    private Schema calculateSchemaForActualTypeArguments(Components components, ParameterizedType parameterizedType) {
        Schema schemaN = null;
        ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType((Type)parameterizedType).resolveAsRef(true));
        if (resolvedSchema.schema != null) {
            schemaN = resolvedSchema.schema;
            Map schemaMap = resolvedSchema.referencedSchemas;
            if (schemaMap != null) {
                schemaMap.forEach((arg_0, arg_1) -> ((Components)components).addSchemas(arg_0, arg_1));
            }
        }
        return schemaN;
    }

    private Schema calculateSchema(Components components, ParameterizedType parameterizedType) {
        Schema schemaN = AnnotationsUtils.resolveSchemaFromType((Class)((Class)parameterizedType.getActualTypeArguments()[0]), null, null);
        if (schemaN.getType() == null) {
            schemaN = this.extractSchema(components, parameterizedType.getActualTypeArguments()[0]);
        }
        return schemaN;
    }

    private void buildApiResponses(Components components, Method method, io.swagger.v3.oas.models.responses.ApiResponses apiResponsesOp, String[] methodProduces, String httpCode, ApiResponse apiResponse) {
        if (apiResponse.getContent() == null) {
            Content content = this.buildContent(components, method, methodProduces);
            apiResponse.setContent(content);
        }
        if (StringUtils.isBlank((CharSequence)apiResponse.getDescription())) {
            apiResponse.setDescription("default response");
        }
        apiResponsesOp.addApiResponse(httpCode, apiResponse);
    }

    private String evaluateResponseStatus(Method method, Class<?> beanType, boolean isGeneric) {
        String responseStatus = null;
        ResponseStatus annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, ResponseStatus.class);
        if (annotation == null && beanType != null) {
            annotation = (ResponseStatus)AnnotatedElementUtils.findMergedAnnotation(beanType, ResponseStatus.class);
        }
        if (annotation != null) {
            responseStatus = annotation.code().toString();
        }
        if (annotation == null && !isGeneric) {
            responseStatus = HttpStatus.OK.toString();
        }
        return responseStatus;
    }
}

