/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.ReflectionUtils;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class MethodAttributes {
    private String[] classProduces;
    private String[] classConsumes;
    private String[] methodProduces = new String[0];
    private String[] methodConsumes = new String[0];
    private boolean methodOverloaded;
    private boolean withApiResponseDoc;

    public MethodAttributes() {
    }

    public MethodAttributes(String[] methodProducesNew) {
        this.methodProduces = methodProducesNew;
    }

    public String[] getClassProduces() {
        return this.classProduces;
    }

    public void setClassProduces(String[] classProduces) {
        this.classProduces = classProduces;
    }

    public String[] getClassConsumes() {
        return this.classConsumes;
    }

    public void setClassConsumes(String[] classConsumes) {
        this.classConsumes = classConsumes;
    }

    public String[] getMethodProduces() {
        return this.methodProduces;
    }

    public void setMethodProduces(String[] methodProduces) {
        this.methodProduces = methodProduces;
    }

    public String[] getMethodConsumes() {
        return this.methodConsumes;
    }

    public void setMethodConsumes(String[] methodConsumes) {
        this.methodConsumes = methodConsumes;
    }

    public void calculateConsumesProduces(Method method) {
        PostMapping reqPostMappringMethod = (PostMapping)ReflectionUtils.getAnnotation((Method)method, PostMapping.class);
        if (reqPostMappringMethod != null) {
            this.fillMethods(reqPostMappringMethod.produces(), reqPostMappringMethod.consumes());
            return;
        }
        GetMapping reqGetMappringMethod = (GetMapping)ReflectionUtils.getAnnotation((Method)method, GetMapping.class);
        if (reqGetMappringMethod != null) {
            this.fillMethods(reqGetMappringMethod.produces(), reqGetMappringMethod.consumes());
            return;
        }
        DeleteMapping reqDeleteMappringMethod = (DeleteMapping)ReflectionUtils.getAnnotation((Method)method, DeleteMapping.class);
        if (reqDeleteMappringMethod != null) {
            this.fillMethods(reqDeleteMappringMethod.produces(), reqDeleteMappringMethod.consumes());
            return;
        }
        PutMapping reqPutMappringMethod = (PutMapping)ReflectionUtils.getAnnotation((Method)method, PutMapping.class);
        if (reqPutMappringMethod != null) {
            this.fillMethods(reqPutMappringMethod.produces(), reqPutMappringMethod.consumes());
            return;
        }
        RequestMapping reqMappringMethod = (RequestMapping)ReflectionUtils.getAnnotation((Method)method, RequestMapping.class);
        if (reqMappringMethod != null) {
            this.fillMethods(reqMappringMethod.produces(), reqMappringMethod.consumes());
        }
    }

    private void fillMethods(String[] produces, String[] consumes) {
        String[] stringArray;
        String[] stringArray2;
        if (ArrayUtils.isNotEmpty((Object[])produces)) {
            stringArray2 = produces;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "*/*";
        }
        this.methodProduces = stringArray2;
        if (ArrayUtils.isNotEmpty((Object[])consumes)) {
            stringArray = consumes;
        } else {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "*/*";
        }
        this.methodConsumes = stringArray;
    }

    public String[] getAllConsumes() {
        return (String[])ArrayUtils.addAll((Object[])this.methodConsumes, (Object[])this.classConsumes);
    }

    public String[] getAllProduces() {
        return (String[])ArrayUtils.addAll((Object[])this.methodProduces, (Object[])this.classProduces);
    }

    public void setMethodOverloaded(boolean overloaded) {
        this.methodOverloaded = overloaded;
    }

    public boolean isMethodOverloaded() {
        return this.methodOverloaded;
    }

    public void setWithApiResponseDoc(boolean withApiDoc) {
        this.withApiResponseDoc = withApiDoc;
    }

    public boolean isNoApiResponseDoc() {
        return !this.withApiResponseDoc;
    }
}

