/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

public class MethodAttributes {
    private String[] classProduces;
    private String[] classConsumes;
    private String[] methodProduces = new String[0];
    private String[] methodConsumes = new String[0];
    private boolean methodOverloaded;
    private boolean withApiResponseDoc;
    private JsonView jsonViewAnnotation;
    private JsonView jsonViewAnnotationForRequestBody;
    private String defaultConsumesMediaType;
    private String defaultProducesMediaType;

    public MethodAttributes(String[] methodProducesNew, String defaultConsumesMediaType, String defaultProducesMediaType) {
        this.methodProduces = methodProducesNew;
        this.defaultConsumesMediaType = defaultConsumesMediaType;
        this.defaultProducesMediaType = defaultProducesMediaType;
    }

    public MethodAttributes(String defaultConsumesMediaType, String defaultProducesMediaType) {
        this.defaultConsumesMediaType = defaultConsumesMediaType;
        this.defaultProducesMediaType = defaultProducesMediaType;
    }

    public String[] getClassProduces() {
        return this.classProduces;
    }

    public void setClassProduces(String[] classProduces) {
        this.classProduces = classProduces;
    }

    public String[] getClassConsumes() {
        return this.classConsumes;
    }

    public void setClassConsumes(String[] classConsumes) {
        this.classConsumes = classConsumes;
    }

    public String[] getMethodProduces() {
        return this.methodProduces;
    }

    public String[] getMethodConsumes() {
        return this.methodConsumes;
    }

    public void calculateConsumesProduces(Method method) {
        PostMapping reqPostMappingMethod = (PostMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, PostMapping.class);
        if (reqPostMappingMethod != null) {
            this.fillMethods(reqPostMappingMethod.produces(), reqPostMappingMethod.consumes());
            return;
        }
        GetMapping reqGetMappingMethod = (GetMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, GetMapping.class);
        if (reqGetMappingMethod != null) {
            this.fillMethods(reqGetMappingMethod.produces(), reqGetMappingMethod.consumes());
            return;
        }
        DeleteMapping reqDeleteMappingMethod = (DeleteMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, DeleteMapping.class);
        if (reqDeleteMappingMethod != null) {
            this.fillMethods(reqDeleteMappingMethod.produces(), reqDeleteMappingMethod.consumes());
            return;
        }
        PutMapping reqPutMappingMethod = (PutMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, PutMapping.class);
        if (reqPutMappingMethod != null) {
            this.fillMethods(reqPutMappingMethod.produces(), reqPutMappingMethod.consumes());
            return;
        }
        RequestMapping reqMappingMethod = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, RequestMapping.class);
        RequestMapping reqMappingClass = (RequestMapping)AnnotatedElementUtils.findMergedAnnotation(method.getDeclaringClass(), RequestMapping.class);
        if (reqMappingMethod != null && reqMappingClass != null) {
            this.fillMethods((String[])ArrayUtils.addAll((Object[])reqMappingMethod.produces(), (Object[])reqMappingClass.produces()), (String[])ArrayUtils.addAll((Object[])reqMappingMethod.consumes(), (Object[])reqMappingClass.consumes()));
        } else if (reqMappingMethod != null) {
            this.fillMethods(reqMappingMethod.produces(), reqMappingMethod.consumes());
        } else if (reqMappingClass != null) {
            this.fillMethods(reqMappingClass.produces(), reqMappingClass.consumes());
        }
    }

    private void fillMethods(String[] produces, String[] consumes) {
        this.methodProduces = ArrayUtils.isNotEmpty((Object[])produces) ? produces : (ArrayUtils.isNotEmpty((Object[])this.classProduces) ? this.classProduces : new String[]{this.defaultProducesMediaType});
        this.methodConsumes = ArrayUtils.isNotEmpty((Object[])consumes) ? consumes : (ArrayUtils.isNotEmpty((Object[])this.classConsumes) ? this.classConsumes : new String[]{this.defaultConsumesMediaType});
    }

    public boolean isMethodOverloaded() {
        return this.methodOverloaded;
    }

    public void setMethodOverloaded(boolean overloaded) {
        this.methodOverloaded = overloaded;
    }

    public void setWithApiResponseDoc(boolean withApiDoc) {
        this.withApiResponseDoc = withApiDoc;
    }

    public boolean isNoApiResponseDoc() {
        return !this.withApiResponseDoc;
    }

    public JsonView getJsonViewAnnotation() {
        return this.jsonViewAnnotation;
    }

    public void setJsonViewAnnotation(JsonView jsonViewAnnotation) {
        this.jsonViewAnnotation = jsonViewAnnotation;
    }

    public JsonView getJsonViewAnnotationForRequestBody() {
        if (this.jsonViewAnnotationForRequestBody == null) {
            return this.jsonViewAnnotation;
        }
        return this.jsonViewAnnotationForRequestBody;
    }

    public void setJsonViewAnnotationForRequestBody(JsonView jsonViewAnnotationForRequestBody) {
        this.jsonViewAnnotationForRequestBody = jsonViewAnnotationForRequestBody;
    }
}

