/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.springdoc.api.annotations.ParameterObject;
import org.springdoc.core.converters.AdditionalModelsConverter;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

class DelegatingMethodParameter
extends MethodParameter {
    private MethodParameter delegate;
    private Annotation[] additionalParameterAnnotations;
    private String parameterName;

    DelegatingMethodParameter(MethodParameter delegate, String parameterName, Annotation[] additionalParameterAnnotations) {
        super(delegate);
        this.delegate = delegate;
        this.additionalParameterAnnotations = additionalParameterAnnotations;
        this.parameterName = parameterName;
    }

    public static MethodParameter[] customize(String[] pNames, MethodParameter[] parameters) {
        ArrayList<DelegatingMethodParameter> explodedParameters = new ArrayList<DelegatingMethodParameter>();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter p = parameters[i];
            if (p.hasParameterAnnotation(ParameterObject.class)) {
                Class paramClass = AdditionalModelsConverter.getReplacement(p.getParameterType());
                Stream.of(paramClass.getDeclaredFields()).map(f -> DelegatingMethodParameter.fromGetterOfField(paramClass, f)).filter(Objects::nonNull).forEach(explodedParameters::add);
                continue;
            }
            String name = pNames != null ? pNames[i] : p.getParameterName();
            explodedParameters.add(new DelegatingMethodParameter(p, name, null));
        }
        return explodedParameters.toArray(new MethodParameter[0]);
    }

    @NonNull
    public Annotation[] getParameterAnnotations() {
        return (Annotation[])ArrayUtils.addAll((Object[])this.delegate.getParameterAnnotations(), (Object[])this.additionalParameterAnnotations);
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public Method getMethod() {
        return this.delegate.getMethod();
    }

    public Constructor<?> getConstructor() {
        return this.delegate.getConstructor();
    }

    public Class<?> getDeclaringClass() {
        return this.delegate.getDeclaringClass();
    }

    public Member getMember() {
        return this.delegate.getMember();
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.delegate.getAnnotatedElement();
    }

    public Executable getExecutable() {
        return this.delegate.getExecutable();
    }

    public MethodParameter withContainingClass(Class<?> containingClass) {
        return this.delegate.withContainingClass(containingClass);
    }

    public Class<?> getContainingClass() {
        return this.delegate.getContainingClass();
    }

    public Class<?> getParameterType() {
        return this.delegate.getParameterType();
    }

    public Type getGenericParameterType() {
        return this.delegate.getGenericParameterType();
    }

    public Class<?> getNestedParameterType() {
        return this.delegate.getNestedParameterType();
    }

    public Type getNestedGenericParameterType() {
        return this.delegate.getNestedGenericParameterType();
    }

    public void initParameterNameDiscovery(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.delegate.initParameterNameDiscovery(parameterNameDiscoverer);
    }

    @Nullable
    static MethodParameter fromGetterOfField(Class<?> paramClass, Field field) {
        try {
            return Stream.of(Introspector.getBeanInfo(paramClass).getPropertyDescriptors()).filter(d -> d.getName().equals(field.getName())).map(PropertyDescriptor::getReadMethod).filter(Objects::nonNull).findFirst().map(method -> new MethodParameter(method, -1)).map(param -> new DelegatingMethodParameter((MethodParameter)param, field.getName(), field.getDeclaredAnnotations())).orElse(null);
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DelegatingMethodParameter that = (DelegatingMethodParameter)((Object)o);
        return Objects.equals(this.delegate, that.delegate) && Arrays.equals(this.additionalParameterAnnotations, that.additionalParameterAnnotations) && Objects.equals(this.parameterName, that.parameterName);
    }

    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.delegate, this.parameterName);
        result = 31 * result + Arrays.hashCode(this.additionalParameterAnnotations);
        return result;
    }
}

