/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.util.CollectionUtils;

public class GroupedOpenApi {
    private final String group;
    private final List<OpenApiCustomiser> openApiCustomisers;
    private final List<String> pathsToMatch;
    private final List<String> packagesToScan;
    private final List<String> packagesToExclude;
    private final List<String> pathsToExclude;

    private GroupedOpenApi(Builder builder) {
        this.group = Objects.requireNonNull(builder.group, "Group name can not be null");
        this.pathsToMatch = builder.pathsToMatch;
        this.packagesToScan = builder.packagesToScan;
        this.packagesToExclude = builder.packagesToExclude;
        this.pathsToExclude = builder.pathsToExclude;
        this.openApiCustomisers = Objects.requireNonNull(builder.openApiCustomisers);
        if (CollectionUtils.isEmpty(this.pathsToMatch) && CollectionUtils.isEmpty(this.packagesToScan) && CollectionUtils.isEmpty(this.pathsToExclude) && CollectionUtils.isEmpty(this.packagesToExclude) && CollectionUtils.isEmpty(this.openApiCustomisers)) {
            throw new IllegalStateException("Packages to scan or paths to filter or openApiCustomisers can not be all null for the group:" + this.group);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getGroup() {
        return this.group;
    }

    public List<String> getPathsToMatch() {
        return this.pathsToMatch;
    }

    public List<String> getPackagesToScan() {
        return this.packagesToScan;
    }

    public List<String> getPackagesToExclude() {
        return this.packagesToExclude;
    }

    public List<String> getPathsToExclude() {
        return this.pathsToExclude;
    }

    public List<OpenApiCustomiser> getOpenApiCustomisers() {
        return this.openApiCustomisers;
    }

    public static class Builder {
        private final List<OpenApiCustomiser> openApiCustomisers = new ArrayList<OpenApiCustomiser>();
        private String group;
        private List<String> pathsToMatch;
        private List<String> packagesToScan;
        private List<String> packagesToExclude;
        private List<String> pathsToExclude;

        private Builder() {
        }

        public Builder setGroup(String group) {
            this.group = group;
            return this;
        }

        public Builder pathsToMatch(String ... pathsToMatch) {
            this.pathsToMatch = Arrays.asList(pathsToMatch);
            return this;
        }

        public Builder packagesToScan(String ... packagesToScan) {
            this.packagesToScan = Arrays.asList(packagesToScan);
            return this;
        }

        public Builder pathsToExclude(String ... pathsToExclude) {
            this.pathsToExclude = Arrays.asList(pathsToExclude);
            return this;
        }

        public Builder packagesToExclude(String ... packagesToExclude) {
            this.packagesToExclude = Arrays.asList(packagesToExclude);
            return this;
        }

        public Builder addOpenApiCustomiser(OpenApiCustomiser openApiCustomiser) {
            this.openApiCustomisers.add(openApiCustomiser);
            return this;
        }

        public GroupedOpenApi build() {
            return new GroupedOpenApi(this);
        }
    }
}

