/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import io.swagger.v3.core.util.PrimitiveType;
import io.swagger.v3.oas.annotations.Parameter;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.springdoc.core.DelegatingMethodParameter;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;

class MethodParameterPojoExtractor {
    private static final Nullable NULLABLE_ANNOTATION = new Nullable(){

        public Class<? extends Annotation> annotationType() {
            return Nullable.class;
        }
    };
    private static final List<Predicate<Class<?>>> SIMPLE_TYPE_PREDICATES = new ArrayList();
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet();

    private MethodParameterPojoExtractor() {
    }

    static Stream<MethodParameter> extractFrom(Class<?> clazz) {
        return MethodParameterPojoExtractor.extractFrom(clazz, "");
    }

    private static Stream<MethodParameter> extractFrom(Class<?> clazz, String fieldNamePrefix) {
        return MethodParameterPojoExtractor.allFieldsOf(clazz).stream().flatMap(f -> MethodParameterPojoExtractor.fromGetterOfField(clazz, f, fieldNamePrefix)).filter(Objects::nonNull);
    }

    private static Stream<MethodParameter> fromGetterOfField(Class<?> paramClass, Field field, String fieldNamePrefix) {
        if (MethodParameterPojoExtractor.isSimpleType(field.getType())) {
            return MethodParameterPojoExtractor.fromSimpleClass(paramClass, field, fieldNamePrefix);
        }
        return MethodParameterPojoExtractor.extractFrom(field.getType(), fieldNamePrefix + field.getName() + ".");
    }

    private static Stream<MethodParameter> fromSimpleClass(Class<?> paramClass, Field field, String fieldNamePrefix) {
        Object[] fieldAnnotations = field.getDeclaredAnnotations();
        if (MethodParameterPojoExtractor.isOptional(field)) {
            fieldAnnotations = (Annotation[])ArrayUtils.add((Object[])fieldAnnotations, (Object)NULLABLE_ANNOTATION);
        }
        try {
            Object[] finalFieldAnnotations = fieldAnnotations;
            return Stream.of(Introspector.getBeanInfo(paramClass).getPropertyDescriptors()).filter(d -> d.getName().equals(field.getName())).map(PropertyDescriptor::getReadMethod).filter(Objects::nonNull).map(method -> new MethodParameter(method, -1)).map(arg_0 -> MethodParameterPojoExtractor.lambda$fromSimpleClass$3(fieldNamePrefix, field, (Annotation[])finalFieldAnnotations, arg_0));
        }
        catch (IntrospectionException e) {
            return Stream.of(new MethodParameter[0]);
        }
    }

    private static boolean isOptional(Field field) {
        Parameter parameter = field.getAnnotation(Parameter.class);
        return parameter == null || !parameter.required();
    }

    private static List<Field> allFieldsOf(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        do {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        } while ((clazz = clazz.getSuperclass()) != null);
        return fields;
    }

    private static boolean isSimpleType(Class<?> clazz) {
        return SIMPLE_TYPE_PREDICATES.stream().anyMatch(p -> p.test(clazz)) || SIMPLE_TYPES.stream().anyMatch(c -> c.isAssignableFrom(clazz));
    }

    private static boolean isSwaggerPrimitiveType(Class<?> clazz) {
        PrimitiveType primitiveType = PrimitiveType.fromType(clazz);
        return primitiveType != null;
    }

    static void addSimpleTypePredicate(Predicate<Class<?>> predicate) {
        SIMPLE_TYPE_PREDICATES.add(predicate);
    }

    static void addSimpleTypes(Class<?> ... classes) {
        SIMPLE_TYPES.addAll(Arrays.asList(classes));
    }

    static void removeSimpleTypes(Class<?> ... classes) {
        SIMPLE_TYPES.removeAll(Arrays.asList(classes));
    }

    private static /* synthetic */ MethodParameter lambda$fromSimpleClass$3(String fieldNamePrefix, Field field, Annotation[] finalFieldAnnotations, MethodParameter param) {
        return new DelegatingMethodParameter(param, fieldNamePrefix + field.getName(), finalFieldAnnotations);
    }

    static {
        SIMPLE_TYPES.add(CharSequence.class);
        SIMPLE_TYPES.add(Optional.class);
        SIMPLE_TYPES.add(OptionalInt.class);
        SIMPLE_TYPES.add(OptionalLong.class);
        SIMPLE_TYPES.add(OptionalDouble.class);
        SIMPLE_TYPES.add(Map.class);
        SIMPLE_TYPES.add(Iterable.class);
        SIMPLE_TYPE_PREDICATES.add(Class::isPrimitive);
        SIMPLE_TYPE_PREDICATES.add(Class::isEnum);
        SIMPLE_TYPE_PREDICATES.add(Class::isArray);
        SIMPLE_TYPE_PREDICATES.add(MethodParameterPojoExtractor::isSwaggerPrimitiveType);
    }
}

