/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import com.fasterxml.jackson.annotation.JsonView;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.media.Encoding;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SpringDocAnnotationsUtils
extends AnnotationsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringDocAnnotationsUtils.class);

    public static Schema resolveSchemaFromType(Class<?> schemaImplementation, Components components, JsonView jsonView, Annotation[] annotations) {
        Schema schemaObject = SpringDocAnnotationsUtils.extractSchema(components, schemaImplementation, jsonView, annotations);
        if (schemaObject != null && StringUtils.isBlank((CharSequence)schemaObject.get$ref()) && StringUtils.isBlank((CharSequence)schemaObject.getType()) && !(schemaObject instanceof ComposedSchema)) {
            schemaObject.setType("string");
        }
        return schemaObject;
    }

    public static Schema extractSchema(Components components, Type returnType, JsonView jsonView, Annotation[] annotations) {
        Schema schemaN = null;
        ResolvedSchema resolvedSchema = null;
        try {
            resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true).jsonViewAnnotation(jsonView).ctxAnnotations(annotations));
        }
        catch (Exception e) {
            LOGGER.warn("Graceful exception occurred", (Throwable)e);
            return null;
        }
        if (resolvedSchema.schema != null) {
            schemaN = resolvedSchema.schema;
            Map schemaMap = resolvedSchema.referencedSchemas;
            if (schemaMap != null) {
                for (Map.Entry entry : schemaMap.entrySet()) {
                    LinkedHashMap componentSchemas = components.getSchemas();
                    if (componentSchemas == null) {
                        componentSchemas = new LinkedHashMap();
                        componentSchemas.put(entry.getKey(), entry.getValue());
                    } else if (!componentSchemas.containsKey(entry.getKey())) {
                        componentSchemas.put(entry.getKey(), entry.getValue());
                    }
                    components.setSchemas(componentSchemas);
                }
            }
        }
        return schemaN;
    }

    public static Schema extractSchema(Components components, Type genericParameterType, JsonView jsonView) {
        return SpringDocAnnotationsUtils.extractSchema(components, genericParameterType, jsonView, null);
    }

    public static Optional<Content> getContent(io.swagger.v3.oas.annotations.media.Content[] annotationContents, String[] classTypes, String[] methodTypes, Schema schema, Components components, JsonView jsonViewAnnotation) {
        if (ArrayUtils.isEmpty((Object[])annotationContents)) {
            return Optional.empty();
        }
        Content content = new Content();
        for (io.swagger.v3.oas.annotations.media.Content annotationContent : annotationContents) {
            MediaType mediaType = SpringDocAnnotationsUtils.getMediaType(schema, components, jsonViewAnnotation, annotationContent);
            ExampleObject[] examples = annotationContent.examples();
            SpringDocAnnotationsUtils.setExamples(mediaType, examples);
            SpringDocAnnotationsUtils.addExtension(annotationContent, mediaType);
            Encoding[] encodings = annotationContent.encoding();
            SpringDocAnnotationsUtils.addEncodingToMediaType(jsonViewAnnotation, mediaType, encodings);
            if (StringUtils.isNotBlank((CharSequence)annotationContent.mediaType())) {
                content.addMediaType(annotationContent.mediaType(), mediaType);
                continue;
            }
            if (mediaType.getSchema() == null) continue;
            SpringDocAnnotationsUtils.applyTypes((String[])classTypes, (String[])methodTypes, (Content)content, (MediaType)mediaType);
        }
        if (content.size() == 0 && annotationContents.length != 1) {
            return Optional.empty();
        }
        return Optional.of(content);
    }

    public static void mergeSchema(Content existingContent, Schema<?> schemaN, String mediaTypeStr) {
        if (existingContent.containsKey((Object)mediaTypeStr)) {
            MediaType mediaType = (MediaType)existingContent.get((Object)mediaTypeStr);
            if (!schemaN.equals((Object)mediaType.getSchema())) {
                ComposedSchema schemaObject;
                Schema firstSchema = mediaType.getSchema();
                if (firstSchema instanceof ComposedSchema) {
                    schemaObject = (ComposedSchema)firstSchema;
                    List listOneOf = schemaObject.getOneOf();
                    if (!CollectionUtils.isEmpty((Collection)listOneOf) && !listOneOf.contains(schemaN)) {
                        schemaObject.addOneOfItem(schemaN);
                    }
                } else {
                    schemaObject = new ComposedSchema();
                    schemaObject.addOneOfItem(schemaN);
                    schemaObject.addOneOfItem(firstSchema);
                }
                mediaType.setSchema((Schema)schemaObject);
                existingContent.addMediaType(mediaTypeStr, mediaType);
            }
        } else {
            existingContent.addMediaType(mediaTypeStr, new MediaType().schema(schemaN));
        }
    }

    private static void addEncodingToMediaType(JsonView jsonViewAnnotation, MediaType mediaType, Encoding[] encodings) {
        for (Encoding encoding : encodings) {
            SpringDocAnnotationsUtils.addEncodingToMediaType((MediaType)mediaType, (Encoding)encoding, (JsonView)jsonViewAnnotation);
        }
    }

    private static void addExtension(io.swagger.v3.oas.annotations.media.Content annotationContent, MediaType mediaType) {
        if (annotationContent.extensions().length > 0) {
            Map extensions = AnnotationsUtils.getExtensions((Extension[])annotationContent.extensions());
            extensions.forEach((arg_0, arg_1) -> ((MediaType)mediaType).addExtension(arg_0, arg_1));
        }
    }

    private static void setExamples(MediaType mediaType, ExampleObject[] examples) {
        if (examples.length == 1 && StringUtils.isBlank((CharSequence)examples[0].name())) {
            SpringDocAnnotationsUtils.getExample((ExampleObject)examples[0], (boolean)true).ifPresent(exampleObject -> mediaType.example(exampleObject.getValue()));
        } else {
            for (ExampleObject example : examples) {
                SpringDocAnnotationsUtils.getExample((ExampleObject)example).ifPresent(exampleObject -> {
                    if (exampleObject.get$ref() != null) {
                        exampleObject.setDescription(null);
                    }
                    mediaType.addExamples(example.name(), exampleObject);
                });
            }
        }
    }

    private static MediaType getMediaType(Schema schema, Components components, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.media.Content annotationContent) {
        MediaType mediaType;
        block6: {
            mediaType = new MediaType();
            if (!annotationContent.schema().hidden()) {
                if (components != null) {
                    try {
                        SpringDocAnnotationsUtils.getSchema((io.swagger.v3.oas.annotations.media.Content)annotationContent, (Components)components, (JsonView)jsonViewAnnotation).ifPresent(arg_0 -> ((MediaType)mediaType).setSchema(arg_0));
                    }
                    catch (Exception e) {
                        if (SpringDocAnnotationsUtils.isArray(annotationContent)) {
                            mediaType.setSchema((Schema)new ArraySchema().items((Schema)new StringSchema()));
                            break block6;
                        }
                        mediaType.setSchema((Schema)new StringSchema());
                    }
                } else {
                    mediaType.setSchema(schema);
                }
            }
        }
        return mediaType;
    }

    private static boolean isArray(io.swagger.v3.oas.annotations.media.Content annotationContent) {
        Class schemaImplementation = annotationContent.schema().implementation();
        boolean isArray = false;
        if (schemaImplementation == Void.class && (schemaImplementation = annotationContent.array().schema().implementation()) != Void.class) {
            isArray = true;
        }
        return isArray;
    }
}

