/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.fn;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.springdoc.core.fn.RouterFunctionData;
import org.springframework.http.HttpMethod;

public class AbstractRouterFunctionVisitor {
    protected List<RouterFunctionData> routerFunctionDatas = new ArrayList<RouterFunctionData>();
    protected List<String> nestedOrPaths = new ArrayList<String>();
    protected List<String> nestedAndPaths = new ArrayList<String>();
    protected List<String> nestedAcceptHeaders = new ArrayList<String>();
    protected List<String> nestedContentTypeHeaders = new ArrayList<String>();
    protected boolean isOr;
    protected boolean isAnd;
    protected RouterFunctionData routerFunctionData;

    public void method(Set<HttpMethod> methods) {
        this.routerFunctionData.setMethods(methods);
    }

    public void path(String pattern) {
        if (this.routerFunctionData != null) {
            this.routerFunctionData.setPath(pattern);
        } else if (this.isAnd) {
            this.nestedAndPaths.add(pattern);
        } else if (this.isOr) {
            this.nestedOrPaths.add(pattern);
        }
    }

    public void header(String name, String value) {
        if ("Accept".equals(name)) {
            this.calculateAccept(value);
        } else if ("Content-Type".equals(name)) {
            this.calculateContentType(value);
        } else {
            this.routerFunctionData.addHeaders(name + "=" + value);
        }
    }

    public List<RouterFunctionData> getRouterFunctionDatas() {
        return this.routerFunctionDatas;
    }

    public void queryParam(String name, String value) {
        this.routerFunctionData.addQueryParams(name, value);
    }

    public void pathExtension(String extension) {
    }

    public void param(String name, String value) {
    }

    public void startAnd() {
        this.isAnd = true;
    }

    public void and() {
    }

    public void endAnd() {
    }

    public void startOr() {
        this.isOr = true;
    }

    public void or() {
    }

    public void endOr() {
    }

    public void startNegate() {
    }

    public void endNegate() {
    }

    protected void computeNested() {
        if (!this.nestedAndPaths.isEmpty()) {
            String nestedPath = String.join((CharSequence)"", this.nestedAndPaths);
            this.routerFunctionDatas.forEach(existingRouterFunctionData -> existingRouterFunctionData.setPath(nestedPath + existingRouterFunctionData.getPath()));
        }
        if (!this.nestedOrPaths.isEmpty()) {
            ArrayList<RouterFunctionData> routerFunctionDatasClone = new ArrayList<RouterFunctionData>();
            for (RouterFunctionData functionData : this.routerFunctionDatas) {
                for (String nestedOrPath : this.nestedOrPaths) {
                    RouterFunctionData routerFunctionDataClone = new RouterFunctionData(nestedOrPath + functionData.getPath(), functionData.getConsumes(), functionData.getProduces(), functionData.getHeaders(), functionData.getQueryParams(), functionData.getMethods());
                    routerFunctionDatasClone.add(routerFunctionDataClone);
                }
            }
            this.routerFunctionDatas = routerFunctionDatasClone;
        }
        if (!this.nestedAcceptHeaders.isEmpty()) {
            this.routerFunctionDatas.forEach(existingRouterFunctionData -> existingRouterFunctionData.addProduces(this.nestedAcceptHeaders));
        }
        if (!this.nestedContentTypeHeaders.isEmpty()) {
            this.routerFunctionDatas.forEach(existingRouterFunctionData -> existingRouterFunctionData.addConsumes(this.nestedContentTypeHeaders));
        }
    }

    private void calculateContentType(String value) {
        if (value.contains(",")) {
            String[] mediaTypes;
            for (String mediaType : mediaTypes = value.substring(1, value.length() - 1).split(", ")) {
                if (this.routerFunctionData != null) {
                    this.routerFunctionData.addConsumes(mediaType);
                    continue;
                }
                this.nestedContentTypeHeaders.addAll(Arrays.asList(mediaTypes));
            }
        } else if (this.routerFunctionData != null) {
            this.routerFunctionData.addConsumes(value);
        } else {
            this.nestedContentTypeHeaders.add(value);
        }
    }

    private void calculateAccept(String value) {
        if (value.contains(",")) {
            String[] mediaTypes;
            for (String mediaType : mediaTypes = value.substring(1, value.length() - 1).split(", ")) {
                if (this.routerFunctionData != null) {
                    this.routerFunctionData.addProduces(mediaType);
                    continue;
                }
                this.nestedAcceptHeaders.addAll(Arrays.asList(mediaTypes));
            }
        } else if (this.routerFunctionData != null) {
            this.routerFunctionData.addProduces(value);
        } else {
            this.nestedAcceptHeaders.add(value);
        }
    }
}

