/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core.providers;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.data.ControllerType;
import org.springdoc.core.data.DataRestRepository;
import org.springdoc.core.data.DataRestRouterOperationService;
import org.springdoc.core.fn.RouterOperation;
import org.springdoc.core.providers.RepositoryRestResourceProvider;
import org.springdoc.core.utils.SpringDocDataRestUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.webmvc.BasePathAwareController;
import org.springframework.data.rest.webmvc.BasePathAwareHandlerMapping;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.alps.AlpsController;
import org.springframework.data.rest.webmvc.json.JacksonMetadata;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

public class SpringRepositoryRestResourceProvider
implements RepositoryRestResourceProvider {
    private static final String SPRING_DATA_REST_PACKAGE = "org.springframework.data.rest";
    public static final String REPOSITORY_SCHEMA_CONTROLLER = "org.springframework.data.rest.webmvc.RepositorySchemaController";
    private static final String REPOSITORY_ENTITY_CONTROLLER = "org.springframework.data.rest.webmvc.RepositoryEntityController";
    private static final String REPOSITORY_SERACH_CONTROLLER = "org.springframework.data.rest.webmvc.RepositorySearchController";
    private static final String REPOSITORY_PROPERTY_CONTROLLER = "org.springframework.data.rest.webmvc.RepositoryPropertyReferenceController";
    private static final String DELEGATING_HANDLER_MAPPING_CLASS = "org.springframework.data.rest.webmvc.config.DelegatingHandlerMapping";
    private static final String DELEGATING_HANDLER_MAPPING_INTERFACE = "org.springframework.data.rest.webmvc.support.DelegatingHandlerMapping";
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringRepositoryRestResourceProvider.class);
    private static Class delegatingHandlerMappingClass;
    private final ResourceMappings mappings;
    private final Repositories repositories;
    private final Associations associations;
    private final DataRestRouterOperationService dataRestRouterOperationService;
    private final PersistentEntities persistentEntities;
    private final ObjectMapper mapper;
    private final ApplicationContext applicationContext;
    private final SpringDocDataRestUtils springDocDataRestUtils;
    private List<HandlerMapping> handlerMappingList;

    public SpringRepositoryRestResourceProvider(ResourceMappings mappings, Repositories repositories, Associations associations, ApplicationContext applicationContext, DataRestRouterOperationService dataRestRouterOperationService, PersistentEntities persistentEntities, ObjectMapper mapper, SpringDocDataRestUtils springDocDataRestUtils) {
        this.mappings = mappings;
        this.repositories = repositories;
        this.associations = associations;
        this.applicationContext = applicationContext;
        this.dataRestRouterOperationService = dataRestRouterOperationService;
        this.persistentEntities = persistentEntities;
        this.mapper = mapper;
        this.springDocDataRestUtils = springDocDataRestUtils;
    }

    @Override
    public List<RouterOperation> getRouterOperations(OpenAPI openAPI, Locale locale) {
        ArrayList<RouterOperation> routerOperationList = new ArrayList<RouterOperation>();
        this.handlerMappingList = this.getHandlerMappingList();
        for (Class domainType : this.repositories) {
            Class repository = this.repositories.getRequiredRepositoryInformation(domainType).getRepositoryInterface();
            DataRestRepository dataRestRepository = new DataRestRepository(domainType, repository, locale);
            ResourceMetadata resourceMetadata = this.mappings.getMetadataFor(domainType);
            PersistentEntity entity = this.persistentEntities.getRequiredPersistentEntity(domainType);
            dataRestRepository.setPersistentEntity(entity);
            JacksonMetadata jackson = new JacksonMetadata(this.mapper, domainType);
            boolean hiddenRepository = AnnotationUtils.findAnnotation((Class)repository, Hidden.class) != null;
            if (hiddenRepository) continue;
            if (resourceMetadata != null && resourceMetadata.isExported()) {
                for (HandlerMapping handlerMapping : this.handlerMappingList) {
                    Map<RequestMappingInfo, HandlerMethod> handlerMethodMapFiltered;
                    Map handlerMethodMap;
                    if (handlerMapping instanceof RepositoryRestHandlerMapping) {
                        RepositoryRestHandlerMapping repositoryRestHandlerMapping = (RepositoryRestHandlerMapping)handlerMapping;
                        handlerMethodMap = repositoryRestHandlerMapping.getHandlerMethods();
                        handlerMethodMapFiltered = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> REPOSITORY_ENTITY_CONTROLLER.equals(((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType().getName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
                        dataRestRepository.setControllerType(ControllerType.ENTITY);
                        this.findControllers(routerOperationList, handlerMethodMapFiltered, resourceMetadata, dataRestRepository, openAPI);
                        Map<RequestMappingInfo, HandlerMethod> handlerMethodMapFilteredMethodMap = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> REPOSITORY_PROPERTY_CONTROLLER.equals(((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType().getName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
                        entity.doWithAssociations(association -> {
                            PersistentProperty property = association.getInverse();
                            if (jackson.isExported(property) && this.associations.isLinkableAssociation(property)) {
                                dataRestRepository.setRelationName(resourceMetadata.getMappingFor(property).getRel().value());
                                dataRestRepository.setControllerType(ControllerType.PROPERTY);
                                dataRestRepository.setCollectionLike(property.isCollectionLike());
                                dataRestRepository.setMap(property.isMap());
                                dataRestRepository.setPropertyType(property.getActualType());
                                this.findControllers(routerOperationList, handlerMethodMapFilteredMethodMap, resourceMetadata, dataRestRepository, openAPI);
                            }
                        });
                        continue;
                    }
                    if (!(handlerMapping instanceof BasePathAwareHandlerMapping)) continue;
                    BasePathAwareHandlerMapping beanBasePathAwareHandlerMapping = (BasePathAwareHandlerMapping)handlerMapping;
                    handlerMethodMap = beanBasePathAwareHandlerMapping.getHandlerMethods();
                    handlerMethodMapFiltered = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> REPOSITORY_SCHEMA_CONTROLLER.equals(((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType().getName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
                    dataRestRepository.setControllerType(ControllerType.SCHEMA);
                    this.findControllers(routerOperationList, handlerMethodMapFiltered, resourceMetadata, dataRestRepository, openAPI);
                    handlerMethodMapFiltered = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> ProfileController.class.equals((Object)((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType()) || AlpsController.class.equals((Object)((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
                    dataRestRepository.setControllerType(ControllerType.GENERAL);
                    this.findControllers(routerOperationList, handlerMethodMapFiltered, resourceMetadata, dataRestRepository, openAPI);
                }
            }
            this.findSearchResourceMappings(openAPI, routerOperationList, this.handlerMappingList, dataRestRepository, resourceMetadata);
        }
        return routerOperationList;
    }

    @Override
    public Map<String, Object> getBasePathAwareControllerEndpoints() {
        return this.applicationContext.getBeansWithAnnotation(BasePathAwareController.class);
    }

    @Override
    public Map getHandlerMethods() {
        this.handlerMappingList = this.getHandlerMappingList();
        return this.handlerMappingList.stream().filter(RequestMappingInfoHandlerMapping.class::isInstance).flatMap(handler -> ((RequestMappingInfoHandlerMapping)handler).getHandlerMethods().entrySet().stream()).filter(entry -> !((HandlerMethod)entry.getValue()).getBeanType().getName().startsWith(SPRING_DATA_REST_PACKAGE) && AnnotatedElementUtils.hasAnnotation((AnnotatedElement)((HandlerMethod)entry.getValue()).getBeanType(), BasePathAwareController.class)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Override
    public void customize(OpenAPI openAPI) {
        this.springDocDataRestUtils.customise(openAPI, this.mappings, this.persistentEntities);
    }

    private List<HandlerMapping> getHandlerMappingList() {
        if (this.handlerMappingList == null) {
            this.handlerMappingList = new ArrayList<HandlerMapping>();
            if (delegatingHandlerMappingClass != null) {
                Object object = this.applicationContext.getBean(delegatingHandlerMappingClass);
                try {
                    this.handlerMappingList = (List)MethodUtils.invokeMethod((Object)object, (String)"getDelegates");
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        }
        return this.handlerMappingList;
    }

    private void findSearchResourceMappings(OpenAPI openAPI, List<RouterOperation> routerOperationList, List<HandlerMapping> handlerMappingList, DataRestRepository dataRestRepository, ResourceMetadata resourceMetadata) {
        for (HandlerMapping handlerMapping : handlerMappingList) {
            SearchResourceMappings searchResourceMappings;
            if (!(handlerMapping instanceof RepositoryRestHandlerMapping)) continue;
            RepositoryRestHandlerMapping repositoryRestHandlerMapping = (RepositoryRestHandlerMapping)handlerMapping;
            Map handlerMethodMap = repositoryRestHandlerMapping.getHandlerMethods();
            Map<RequestMappingInfo, HandlerMethod> handlerMethodMapFiltered = handlerMethodMap.entrySet().stream().filter(requestMappingInfoHandlerMethodEntry -> REPOSITORY_SERACH_CONTROLLER.equals(((HandlerMethod)requestMappingInfoHandlerMethodEntry.getValue()).getBeanType().getName())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a1, a2) -> a1));
            ResourceMetadata metadata = this.associations.getMetadataFor(dataRestRepository.getDomainType());
            if (metadata == null || !metadata.isExported() || !(searchResourceMappings = metadata.getSearchResourceMappings()).isExported()) continue;
            this.findSearchControllers(routerOperationList, handlerMethodMapFiltered, resourceMetadata, dataRestRepository, openAPI, searchResourceMappings);
        }
    }

    private List<RouterOperation> findSearchControllers(List<RouterOperation> routerOperationList, Map<RequestMappingInfo, HandlerMethod> handlerMethodMap, ResourceMetadata resourceMetadata, DataRestRepository dataRestRepository, OpenAPI openAPI, SearchResourceMappings searchResourceMappings) {
        Stream methodResourceMappingStream = searchResourceMappings.getExportedMappings();
        methodResourceMappingStream.forEach(methodResourceMapping -> this.dataRestRouterOperationService.buildSearchRouterOperationList(routerOperationList, handlerMethodMap, resourceMetadata, dataRestRepository, openAPI, (MethodResourceMapping)methodResourceMapping));
        return routerOperationList;
    }

    private List<RouterOperation> findControllers(List<RouterOperation> routerOperationList, Map<RequestMappingInfo, HandlerMethod> handlerMethodMap, ResourceMetadata resourceMetadata, DataRestRepository dataRestRepository, OpenAPI openAPI) {
        this.dataRestRouterOperationService.buildEntityRouterOperationList(routerOperationList, handlerMethodMap, resourceMetadata, dataRestRepository, openAPI);
        return routerOperationList;
    }

    static {
        try {
            delegatingHandlerMappingClass = Class.forName(DELEGATING_HANDLER_MAPPING_CLASS);
        }
        catch (ClassNotFoundException e) {
            try {
                delegatingHandlerMappingClass = Class.forName(DELEGATING_HANDLER_MAPPING_INTERFACE);
            }
            catch (ClassNotFoundException exception) {
                LOGGER.trace(e.getMessage());
            }
        }
    }
}

