/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.ui;

import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.ui.SwaggerWelcome;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={OpenAPIBuilder.class})
public class SwaggerConfig
extends WebMvcConfigurerAdapter {
    @Value(value="${springdoc.swagger-ui.path:#{T(org.springdoc.core.Constants).DEFAULT_SWAGGER_UI_PATH}}")
    private String swaggerPath;
    @Value(value="${springdoc.webjars.prefix:#{T(org.springdoc.core.Constants).DEFAULT_WEB_JARS_PREFIX_URL}}")
    private String webJarsPrefixUrl;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String uiRootPath = "";
        if (this.swaggerPath.contains("/")) {
            uiRootPath = this.swaggerPath.substring(0, this.swaggerPath.lastIndexOf(47));
        }
        uiRootPath = uiRootPath + "/**";
        String webJarsLocation = this.webJarsPrefixUrl + "/";
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/swagger-ui.css"}).addResourceLocations(new String[]{webJarsLocation}).resourceChain(false);
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/swagger-ui-standalone-preset.js"}).addResourceLocations(new String[]{webJarsLocation}).resourceChain(false);
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/swagger-ui-bundle.js"}).addResourceLocations(new String[]{webJarsLocation}).resourceChain(false);
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/index.html"}).addResourceLocations(new String[]{webJarsLocation}).resourceChain(false);
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/favicon-32x32.png"}).addResourceLocations(new String[]{webJarsLocation}).resourceChain(false);
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui/favicon-16x16.png"}).addResourceLocations(new String[]{webJarsLocation}).resourceChain(false);
    }

    @Bean
    @ConditionalOnProperty(name={"springdoc.swagger-ui.enabled"}, matchIfMissing=true)
    public SwaggerWelcome swaggerWelcome() {
        return new SwaggerWelcome();
    }
}

