/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.ui;

import java.util.List;
import java.util.Optional;
import org.springdoc.core.SwaggerUiConfigParameters;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.webmvc.ui.SwaggerIndexTransformer;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.lang.Nullable;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.ViewResolverRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.ResourceTransformer;

public class SwaggerWebMvcConfigurer
implements WebMvcConfigurer {
    private String swaggerPath;
    private SwaggerIndexTransformer swaggerIndexTransformer;
    private Optional<ActuatorProvider> actuatorProvider;

    public SwaggerWebMvcConfigurer(SwaggerUiConfigParameters swaggerUiConfigParameters, SwaggerIndexTransformer swaggerIndexTransformer, Optional<ActuatorProvider> actuatorProvider) {
        this.swaggerPath = swaggerUiConfigParameters.getPath();
        this.swaggerIndexTransformer = swaggerIndexTransformer;
        this.actuatorProvider = actuatorProvider;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        StringBuilder uiRootPath = new StringBuilder();
        if (this.swaggerPath.contains("/")) {
            uiRootPath.append(this.swaggerPath, 0, this.swaggerPath.lastIndexOf("/"));
        }
        if (this.actuatorProvider.isPresent() && this.actuatorProvider.get().isUseManagementPort()) {
            uiRootPath.append(this.actuatorProvider.get().getBasePath());
        }
        registry.addResourceHandler(new String[]{uiRootPath + "/swagger-ui" + "*/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"}).resourceChain(false).addTransformer((ResourceTransformer)this.swaggerIndexTransformer);
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
    }

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
    }

    public void addFormatters(FormatterRegistry registry) {
    }

    public void addInterceptors(InterceptorRegistry registry) {
    }

    public void addCorsMappings(CorsRegistry registry) {
    }

    public void addViewControllers(ViewControllerRegistry registry) {
    }

    public void configureViewResolvers(ViewResolverRegistry registry) {
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    public void extendMessageConverters(List<HttpMessageConverter<?>> converters) {
    }

    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    public void extendHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
    }

    @Nullable
    public Validator getValidator() {
        return null;
    }

    @Nullable
    public MessageCodesResolver getMessageCodesResolver() {
        return null;
    }
}

