/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.api.ActuatorProvider;
import org.springdoc.api.OpenApiResource;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
public class MultipleOpenApiResource
implements InitializingBean {
    private Map<String, OpenApiResource> groupedOpenApiResources;
    private final List<GroupedOpenApi> groupedOpenApis;
    private final ObjectFactory<OpenAPIBuilder> defaultOpenAPIBuilder;
    private final AbstractRequestBuilder requestBuilder;
    private final AbstractResponseBuilder responseBuilder;
    private final OperationBuilder operationParser;
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    private final Optional<ActuatorProvider> servletContextProvider;
    @Value(value="${springdoc.show-actuator:false}")
    private boolean showActuator;

    public MultipleOpenApiResource(List<GroupedOpenApi> groupedOpenApis, ObjectFactory<OpenAPIBuilder> defaultOpenAPIBuilder, AbstractRequestBuilder requestBuilder, AbstractResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> servletContextProvider) {
        this.groupedOpenApis = groupedOpenApis;
        this.defaultOpenAPIBuilder = defaultOpenAPIBuilder;
        this.requestBuilder = requestBuilder;
        this.responseBuilder = responseBuilder;
        this.operationParser = operationParser;
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.servletContextProvider = servletContextProvider;
    }

    public void afterPropertiesSet() throws Exception {
        this.groupedOpenApiResources = this.groupedOpenApis.stream().collect(Collectors.toMap(GroupedOpenApi::getGroup, item -> new OpenApiResource((OpenAPIBuilder)this.defaultOpenAPIBuilder.getObject(), this.requestBuilder, this.responseBuilder, this.operationParser, this.requestMappingHandlerMapping, this.servletContextProvider, Optional.of(item.getOpenApiCustomisers()), item.getPathsToMatch(), item.getPackagesToScan(), this.showActuator)));
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}/{group}"}, produces={"application/json"})
    public String openapiJson(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl, @PathVariable String group) throws JsonProcessingException {
        return this.getOpenApiResourceOrThrow(group).openapiJson(request, apiDocsUrl + "/" + group);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml/{group}"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl, @PathVariable String group) throws JsonProcessingException {
        return this.getOpenApiResourceOrThrow(group).openapiYaml(request, apiDocsUrl + "/" + group);
    }

    private OpenApiResource getOpenApiResourceOrThrow(String group) {
        OpenApiResource openApiResource = this.groupedOpenApiResources.get(group);
        if (openApiResource == null) {
            throw new IllegalStateException("No OpenAPI resource found for group " + group);
        }
        return openApiResource;
    }
}

