/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.models.OpenAPI;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springdoc.api.AbstractOpenApiResource;
import org.springdoc.api.ActuatorProvider;
import org.springdoc.core.AbstractRequestBuilder;
import org.springdoc.core.AbstractResponseBuilder;
import org.springdoc.core.OpenAPIBuilder;
import org.springdoc.core.OperationBuilder;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;

@RestController
public class OpenApiResource
extends AbstractOpenApiResource {
    private final RequestMappingInfoHandlerMapping requestMappingHandlerMapping;
    private final Optional<ActuatorProvider> servletContextProvider;
    @Value(value="${springdoc.show-actuator:false}")
    private boolean showActuator;

    public OpenApiResource(OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, AbstractResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> servletContextProvider, Optional<List<OpenApiCustomiser>> openApiCustomisers) {
        super(openAPIBuilder, requestBuilder, responseBuilder, operationParser, openApiCustomisers);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.servletContextProvider = servletContextProvider;
    }

    public OpenApiResource(OpenAPIBuilder openAPIBuilder, AbstractRequestBuilder requestBuilder, AbstractResponseBuilder responseBuilder, OperationBuilder operationParser, RequestMappingInfoHandlerMapping requestMappingHandlerMapping, Optional<ActuatorProvider> servletContextProvider, Optional<List<OpenApiCustomiser>> openApiCustomisers, List<String> pathsToMatch, List<String> packagesToScan, boolean showActuator, boolean cacheDisabled) {
        super(openAPIBuilder, requestBuilder, responseBuilder, operationParser, openApiCustomisers, pathsToMatch, packagesToScan, cacheDisabled);
        this.requestMappingHandlerMapping = requestMappingHandlerMapping;
        this.servletContextProvider = servletContextProvider;
        this.showActuator = showActuator;
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}"}, produces={"application/json"})
    public String openapiJson(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Json.mapper().writeValueAsString((Object)openAPI);
    }

    @Operation(hidden=true)
    @GetMapping(value={"${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml"}, produces={"application/vnd.oai.openapi"})
    public String openapiYaml(HttpServletRequest request, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl) throws JsonProcessingException {
        this.calculateServerUrl(request, apiDocsUrl);
        OpenAPI openAPI = this.getOpenApi();
        return Yaml.mapper().writeValueAsString((Object)openAPI);
    }

    protected void getPaths(Map<String, Object> restControllers) {
        Map map = this.requestMappingHandlerMapping.getHandlerMethods();
        this.calculatePath(restControllers, map);
        if (this.showActuator && this.servletContextProvider.isPresent()) {
            map = this.servletContextProvider.get().getWebMvcHandlerMapping().getHandlerMethods();
            HashSet handlerMethods = new HashSet(map.values());
            this.openAPIBuilder.addTag(handlerMethods, "Actuator");
            this.calculatePath(restControllers, map);
        }
    }

    private void calculatePath(Map<String, Object> restControllers, Map<RequestMappingInfo, HandlerMethod> map) {
        for (Map.Entry<RequestMappingInfo, HandlerMethod> entry : map.entrySet()) {
            RequestMappingInfo requestMappingInfo = entry.getKey();
            HandlerMethod handlerMethod = entry.getValue();
            PatternsRequestCondition patternsRequestCondition = requestMappingInfo.getPatternsCondition();
            Set patterns = patternsRequestCondition.getPatterns();
            LinkedHashMap regexMap = new LinkedHashMap();
            for (String pattern : patterns) {
                String operationPath = PathUtils.parsePath((String)pattern, regexMap);
                if (!this.isRestController(restControllers, handlerMethod, operationPath) || !this.isPackageToScan(handlerMethod.getBeanType().getPackage().getName()) || !this.isPathToMatch(operationPath)) continue;
                Set requestMethods = requestMappingInfo.getMethodsCondition().getMethods();
                this.calculatePath(this.openAPIBuilder, handlerMethod, operationPath, requestMethods);
            }
        }
    }

    private boolean isRestController(Map<String, Object> restControllers, HandlerMethod handlerMethod, String operationPath) {
        boolean result;
        if (this.showActuator) {
            result = operationPath.startsWith("/");
        } else {
            ResponseBody responseBodyAnnotation = (ResponseBody)ReflectionUtils.getAnnotation((Class)handlerMethod.getBeanType(), ResponseBody.class);
            if (responseBodyAnnotation == null) {
                responseBodyAnnotation = (ResponseBody)ReflectionUtils.getAnnotation((Method)handlerMethod.getMethod(), ResponseBody.class);
            }
            result = operationPath.startsWith("/") && (restControllers.containsKey(handlerMethod.getBean().toString()) || responseBodyAnnotation != null && AnnotationUtils.findAnnotation((Class)handlerMethod.getBeanType(), Hidden.class) == null);
        }
        return result;
    }

    private void calculateServerUrl(HttpServletRequest request, String apiDocsUrl) {
        String requestUrl = this.decode(request.getRequestURL().toString());
        String calculatedUrl = requestUrl.substring(0, requestUrl.length() - apiDocsUrl.length());
        this.openAPIBuilder.setServerBaseUrl(calculatedUrl);
    }
}

