/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.configuration.JobFactory;
import org.springframework.batch.core.configuration.ListableJobRegistry;
import org.springframework.batch.core.configuration.support.ApplicationContextJobFactory;
import org.springframework.batch.core.configuration.support.ClassPathXmlApplicationContextFactory;
import org.springframework.batch.core.configuration.support.MapJobRegistry;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathXmlJobRegistry
implements ListableJobRegistry,
ApplicationContextAware,
InitializingBean {
    private static Log logger = LogFactory.getLog(ClassPathXmlJobRegistry.class);
    private List<Resource> jobPaths;
    private ApplicationContext parent;
    private ListableJobRegistry jobRegistry = new MapJobRegistry();

    public void setJobPaths(Resource[] jobPaths) {
        this.jobPaths = Arrays.asList(jobPaths);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parent = applicationContext;
    }

    @Override
    public Job getJob(String name) throws NoSuchJobException {
        return this.jobRegistry.getJob(name);
    }

    public void afterPropertiesSet() throws Exception {
        for (Resource resource : this.jobPaths) {
            String[] names;
            ClassPathXmlApplicationContextFactory applicationContextFactory = new ClassPathXmlApplicationContextFactory();
            applicationContextFactory.setPath(resource);
            applicationContextFactory.setApplicationContext(this.parent);
            ConfigurableApplicationContext context = applicationContextFactory.createApplicationContext();
            String[] stringArray = names = context.getBeanNamesForType(Job.class);
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                logger.debug((Object)("Registering job: " + name + " from context: " + resource));
                ApplicationContextJobFactory jobFactory = new ApplicationContextJobFactory(applicationContextFactory, name);
                this.jobRegistry.register(jobFactory);
                ++n2;
            }
        }
        if (this.jobRegistry.getJobNames().isEmpty()) {
            throw new NoSuchJobException("Could not locate any jobs in resources provided.");
        }
    }

    @Override
    public Collection<String> getJobNames() {
        return this.jobRegistry.getJobNames();
    }

    @Override
    public void register(JobFactory jobFactory) throws DuplicateJobException {
        this.jobRegistry.register(jobFactory);
    }

    @Override
    public void unregister(String jobName) {
        this.jobRegistry.unregister(jobName);
    }
}

