/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.configuration.xml.DecisionParser;
import org.springframework.batch.core.configuration.xml.InlineStepParser;
import org.springframework.batch.core.configuration.xml.SplitParser;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.support.SimpleFlow;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowParser
extends AbstractSingleBeanDefinitionParser {
    private static final String ID_ATTR = "id";
    private static final String STEP_ELE = "step";
    private static final String DECISION_ELE = "decision";
    private static final String SPLIT_ELE = "split";
    private static final String NEXT_ATTR = "next";
    private static final String NEXT_ELE = "next";
    private static final String END_ELE = "end";
    private static final String FAIL_ELE = "fail";
    private static final String STOP_ELE = "stop";
    private static final String ON_ATTR = "on";
    private static final String TO_ATTR = "to";
    private static final String RESTART_ATTR = "restart";
    private static final String EXIT_CODE_ATTR = "exit-code";
    private static final InlineStepParser stepParser = new InlineStepParser();
    private static final DecisionParser decisionParser = new DecisionParser();
    private static int endCounter = 0;
    private final String flowName;
    private final String jobFactoryRef;

    public FlowParser(String flowName, String jobFactoryRef) {
        this.flowName = flowName;
        this.jobFactoryRef = jobFactoryRef;
    }

    protected Class<SimpleFlow> getBeanClass(Element element) {
        return SimpleFlow.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ArrayList<BeanDefinition> stateTransitions = new ArrayList<BeanDefinition>();
        SplitParser splitParser = new SplitParser(this.jobFactoryRef);
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), parserContext.extractSource((Object)element));
        parserContext.pushContainingComponent(compositeDef);
        boolean stepExists = false;
        HashMap<String, Set<String>> reachableElementMap = new HashMap<String, Set<String>>();
        String startElement = null;
        NodeList children = element.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            if (node instanceof Element) {
                String nodeName = node.getLocalName();
                Element child = (Element)node;
                if (nodeName.equals(STEP_ELE)) {
                    stateTransitions.addAll(stepParser.parse(child, parserContext, this.jobFactoryRef));
                    stepExists = true;
                } else if (nodeName.equals(DECISION_ELE)) {
                    stateTransitions.addAll(decisionParser.parse(child, parserContext));
                } else if (nodeName.equals(SPLIT_ELE)) {
                    stateTransitions.addAll(splitParser.parse(child, new ParserContext(parserContext.getReaderContext(), parserContext.getDelegate(), (BeanDefinition)builder.getBeanDefinition())));
                    stepExists = true;
                }
                if (Arrays.asList(STEP_ELE, DECISION_ELE, SPLIT_ELE).contains(nodeName)) {
                    reachableElementMap.put(child.getAttribute(ID_ATTR), this.findReachableElements(child));
                    if (startElement == null) {
                        startElement = child.getAttribute(ID_ATTR);
                    }
                }
            }
            ++i;
        }
        if (!stepExists && !StringUtils.hasText((String)element.getAttribute("parent"))) {
            parserContext.getReaderContext().error("The flow [" + this.flowName + "] must contain at least one step", (Object)element);
        }
        HashSet<String> allReachableElements = new HashSet<String>();
        this.findAllReachableElements(startElement, reachableElementMap, allReachableElements);
        for (String elementId : reachableElementMap.keySet()) {
            if (allReachableElements.contains(elementId)) continue;
            parserContext.getReaderContext().error("The element [" + elementId + "] is unreachable", (Object)element);
        }
        builder.addConstructorArgValue((Object)this.flowName);
        ManagedList managedList = new ManagedList();
        managedList.addAll(stateTransitions);
        builder.addPropertyValue("stateTransitions", (Object)managedList);
        builder.setRole(2);
        parserContext.popAndRegisterContainingComponent();
    }

    private Set<String> findReachableElements(Element element) {
        HashSet<String> reachableElements = new HashSet<String>();
        String nextAttribute = element.getAttribute("next");
        if (StringUtils.hasText((String)nextAttribute)) {
            reachableElements.add(nextAttribute);
        }
        List nextElements = DomUtils.getChildElementsByTagName((Element)element, (String)"next");
        for (Element nextElement : nextElements) {
            String toAttribute = nextElement.getAttribute(TO_ATTR);
            reachableElements.add(toAttribute);
        }
        List stopElements = DomUtils.getChildElementsByTagName((Element)element, (String)STOP_ELE);
        for (Element stopElement : stopElements) {
            String restartAttribute = stopElement.getAttribute(RESTART_ATTR);
            reachableElements.add(restartAttribute);
        }
        return reachableElements;
    }

    private void findAllReachableElements(String startElement, Map<String, Set<String>> reachableElementMap, Set<String> accumulator) {
        Set<String> reachableIds = reachableElementMap.get(startElement);
        accumulator.add(startElement);
        if (reachableIds != null) {
            for (String reachable : reachableIds) {
                if (accumulator.contains(reachable)) continue;
                this.findAllReachableElements(reachable, reachableElementMap, accumulator);
            }
        }
    }

    protected static Collection<BeanDefinition> getNextElements(ParserContext parserContext, BeanDefinition stateDef, Element element) {
        return FlowParser.getNextElements(parserContext, null, stateDef, element);
    }

    protected static Collection<BeanDefinition> getNextElements(ParserContext parserContext, String stepId, BeanDefinition stateDef, Element element) {
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        String shortNextAttribute = element.getAttribute("next");
        boolean hasNextAttribute = StringUtils.hasText((String)shortNextAttribute);
        if (hasNextAttribute) {
            list.add(FlowParser.getStateTransitionReference(parserContext, stateDef, null, shortNextAttribute));
        }
        boolean transitionElementExists = false;
        ArrayList<String> patterns = new ArrayList<String>();
        String[] stringArray = new String[]{"next", STOP_ELE, END_ELE, FAIL_ELE};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String transitionName = stringArray[n2];
            List transitionElements = DomUtils.getChildElementsByTagName((Element)element, (String)transitionName);
            for (Element transitionElement : transitionElements) {
                FlowParser.verifyUniquePattern(transitionElement, patterns, element, parserContext);
                list.addAll(FlowParser.parseTransitionElement(transitionElement, stepId, stateDef, parserContext));
                transitionElementExists = true;
            }
            ++n2;
        }
        if (!transitionElementExists) {
            list.addAll(FlowParser.createTransition(FlowExecutionStatus.FAILED, FlowExecutionStatus.FAILED.getName(), null, null, stateDef, parserContext, false));
            if (!hasNextAttribute) {
                list.addAll(FlowParser.createTransition(FlowExecutionStatus.COMPLETED, null, null, null, stateDef, parserContext, false));
            }
        } else if (hasNextAttribute) {
            parserContext.getReaderContext().error("The <" + element.getNodeName() + "/> may not contain a '" + "next" + "' attribute and a transition element", (Object)element);
        }
        return list;
    }

    private static void verifyUniquePattern(Element transitionElement, List<String> patterns, Element element, ParserContext parserContext) {
        String onAttribute = transitionElement.getAttribute(ON_ATTR);
        if (patterns.contains(onAttribute)) {
            parserContext.getReaderContext().error("Duplicate transition pattern found for '" + onAttribute + "'", (Object)element);
        }
        patterns.add(onAttribute);
    }

    private static Collection<BeanDefinition> parseTransitionElement(Element transitionElement, String stateId, BeanDefinition stateDef, ParserContext parserContext) {
        FlowExecutionStatus status = FlowParser.getBatchStatusFromEndTransitionName(transitionElement.getNodeName());
        String onAttribute = transitionElement.getAttribute(ON_ATTR);
        String restartAttribute = transitionElement.getAttribute(RESTART_ATTR);
        String nextAttribute = transitionElement.getAttribute(TO_ATTR);
        if (!StringUtils.hasText((String)nextAttribute)) {
            nextAttribute = restartAttribute;
        }
        boolean abandon = stateId != null && StringUtils.hasText((String)restartAttribute) && !restartAttribute.equals(stateId);
        String exitCodeAttribute = transitionElement.getAttribute(EXIT_CODE_ATTR);
        return FlowParser.createTransition(status, onAttribute, nextAttribute, exitCodeAttribute, stateDef, parserContext, abandon);
    }

    private static Collection<BeanDefinition> createTransition(FlowExecutionStatus status, String on, String next, String exitCode, BeanDefinition stateDef, ParserContext parserContext, boolean abandon) {
        BeanDefinition endState = null;
        if (status == FlowExecutionStatus.STOPPED || status == FlowExecutionStatus.COMPLETED || status == FlowExecutionStatus.FAILED) {
            BeanDefinitionBuilder endBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.state.EndState");
            boolean exitCodeExists = StringUtils.hasText((String)exitCode);
            endBuilder.addConstructorArgValue((Object)status);
            endBuilder.addConstructorArgValue((Object)(exitCodeExists ? exitCode : status.getName()));
            String endName = String.valueOf(status == FlowExecutionStatus.STOPPED ? STOP_ELE : (status == FlowExecutionStatus.FAILED ? FAIL_ELE : END_ELE)) + endCounter++;
            endBuilder.addConstructorArgValue((Object)endName);
            endBuilder.addConstructorArgValue((Object)abandon);
            String nextOnEnd = exitCodeExists ? null : next;
            endState = FlowParser.getStateTransitionReference(parserContext, (BeanDefinition)endBuilder.getBeanDefinition(), null, nextOnEnd);
            next = endName;
        }
        ArrayList<BeanDefinition> list = new ArrayList<BeanDefinition>();
        list.add(FlowParser.getStateTransitionReference(parserContext, stateDef, on, next));
        if (endState != null) {
            list.add(endState);
        }
        return list;
    }

    private static FlowExecutionStatus getBatchStatusFromEndTransitionName(String elementName) {
        if (STOP_ELE.equals(elementName)) {
            return FlowExecutionStatus.STOPPED;
        }
        if (END_ELE.equals(elementName)) {
            return FlowExecutionStatus.COMPLETED;
        }
        if (FAIL_ELE.equals(elementName)) {
            return FlowExecutionStatus.FAILED;
        }
        return FlowExecutionStatus.UNKNOWN;
    }

    public static BeanDefinition getStateTransitionReference(ParserContext parserContext, BeanDefinition stateDefinition, String on, String next) {
        BeanDefinitionBuilder nextBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.job.flow.support.StateTransition");
        nextBuilder.addConstructorArgValue((Object)stateDefinition);
        if (StringUtils.hasText((String)on)) {
            nextBuilder.addConstructorArgValue((Object)on);
        }
        if (StringUtils.hasText((String)next)) {
            nextBuilder.setFactoryMethod("createStateTransition");
            nextBuilder.addConstructorArgValue((Object)next);
        } else {
            nextBuilder.setFactoryMethod("createEndStateTransition");
        }
        return nextBuilder.getBeanDefinition();
    }
}

