/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class JobRepositoryParser
extends AbstractSingleBeanDefinitionParser {
    protected String getBeanClassName(Element element) {
        return "org.springframework.batch.core.repository.support.JobRepositoryFactoryBean";
    }

    protected void doParse(Element element, BeanDefinitionBuilder builder) {
        String dataSource = element.getAttribute("data-source");
        String transactionManager = element.getAttribute("transaction-manager");
        String isolationLevelForCreate = element.getAttribute("isolation-level-for-create");
        String tablePrefix = element.getAttribute("table-prefix");
        RuntimeBeanReference ds = new RuntimeBeanReference(dataSource);
        builder.addPropertyValue("dataSource", (Object)ds);
        RuntimeBeanReference tx = new RuntimeBeanReference(transactionManager);
        builder.addPropertyValue("transactionManager", (Object)tx);
        if (StringUtils.hasText((String)isolationLevelForCreate)) {
            builder.addPropertyValue("isolationLevelForCreate", (Object)("ISOLATION_" + isolationLevelForCreate));
        }
        if (StringUtils.hasText((String)tablePrefix)) {
            builder.addPropertyValue("tablePrefix", (Object)tablePrefix);
        }
        builder.setRole(1);
    }
}

