/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Collection;
import java.util.HashSet;
import org.springframework.batch.classify.BinaryExceptionClassifier;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.item.FaultTolerantStepFactoryBean;
import org.springframework.batch.core.step.item.SimpleStepFactoryBean;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemStream;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.repeat.CompletionPolicy;
import org.springframework.batch.retry.RetryListener;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StepParserStepFactoryBean<I, O>
implements FactoryBean,
BeanNameAware {
    private String name;
    private Boolean allowStartIfComplete;
    private JobRepository jobRepository;
    private Integer startLimit;
    private Tasklet tasklet;
    private PlatformTransactionManager transactionManager;
    private StepListener[] listeners;
    private Collection<Class<? extends Throwable>> noRollbackExceptionClasses;
    private Integer transactionTimeout;
    private Propagation propagation;
    private Isolation isolation;
    private Integer cacheCapacity;
    private CompletionPolicy chunkCompletionPolicy;
    private Integer commitInterval;
    private Boolean isReaderTransactionalQueue;
    private Integer retryLimit;
    private Integer skipLimit;
    private TaskExecutor taskExecutor;
    private Integer throttleLimit;
    private ItemReader<? extends I> itemReader;
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;
    private RetryListener[] retryListeners;
    private Collection<Class<? extends Throwable>> skippableExceptionClasses;
    private Collection<Class<? extends Throwable>> retryableExceptionClasses;
    private Collection<Class<? extends Throwable>> fatalExceptionClasses;
    private ItemStream[] streams;
    private boolean hasChunkElement = false;

    StepParserStepFactoryBean() {
    }

    public final Object getObject() throws Exception {
        if (this.hasChunkElement) {
            Assert.isNull((Object)this.tasklet, (String)("Step [" + this.name + "] has both a <chunk/> element and a 'ref' attribute  referencing a Tasklet."));
            this.validateFaultTolerantSettings();
            if (this.isFaultTolerant()) {
                FaultTolerantStepFactoryBean fb = new FaultTolerantStepFactoryBean();
                this.configureSimple(fb);
                this.configureFaultTolerant(fb);
                return fb.getObject();
            }
            SimpleStepFactoryBean fb = new SimpleStepFactoryBean();
            this.configureSimple(fb);
            return fb.getObject();
        }
        if (this.tasklet != null) {
            TaskletStep ts = new TaskletStep();
            this.configureTaskletStep(ts);
            return ts;
        }
        throw new IllegalStateException("Step [" + this.name + "] has neither a <chunk/> element nor a 'ref' attribute referencing a Tasklet.");
    }

    private void configureSimple(SimpleStepFactoryBean<I, O> fb) {
        if (this.name != null) {
            fb.setBeanName(this.name);
        }
        if (this.allowStartIfComplete != null) {
            fb.setAllowStartIfComplete(this.allowStartIfComplete);
        }
        if (this.jobRepository != null) {
            fb.setJobRepository(this.jobRepository);
        }
        if (this.startLimit != null) {
            fb.setStartLimit(this.startLimit);
        }
        if (this.transactionManager != null) {
            fb.setTransactionManager(this.transactionManager);
        }
        if (this.listeners != null) {
            fb.setListeners(this.listeners);
        }
        if (this.transactionTimeout != null) {
            fb.setTransactionTimeout(this.transactionTimeout);
        }
        if (this.propagation != null) {
            fb.setPropagation(this.propagation);
        }
        if (this.isolation != null) {
            fb.setIsolation(this.isolation);
        }
        if (this.chunkCompletionPolicy != null) {
            fb.setChunkCompletionPolicy(this.chunkCompletionPolicy);
        }
        if (this.commitInterval != null) {
            fb.setCommitInterval(this.commitInterval);
        }
        if (this.taskExecutor != null) {
            fb.setTaskExecutor(this.taskExecutor);
        }
        if (this.throttleLimit != null) {
            fb.setThrottleLimit(this.throttleLimit);
        }
        if (this.itemReader != null) {
            fb.setItemReader(this.itemReader);
        }
        if (this.itemProcessor != null) {
            fb.setItemProcessor(this.itemProcessor);
        }
        if (this.itemWriter != null) {
            fb.setItemWriter(this.itemWriter);
        }
        if (this.streams != null) {
            fb.setStreams(this.streams);
        }
    }

    private void configureFaultTolerant(FaultTolerantStepFactoryBean<I, O> fb) {
        if (this.cacheCapacity != null) {
            fb.setCacheCapacity(this.cacheCapacity);
        }
        if (this.isReaderTransactionalQueue != null) {
            fb.setIsReaderTransactionalQueue(this.isReaderTransactionalQueue);
        }
        if (this.retryLimit != null) {
            fb.setRetryLimit(this.retryLimit);
        }
        if (this.skipLimit != null) {
            fb.setSkipLimit(this.skipLimit);
        }
        if (this.retryListeners != null) {
            fb.setRetryListeners(this.retryListeners);
        }
        if (this.skippableExceptionClasses != null) {
            fb.setSkippableExceptionClasses(this.skippableExceptionClasses);
        }
        if (this.retryableExceptionClasses != null) {
            fb.setRetryableExceptionClasses(this.retryableExceptionClasses);
        }
        if (this.fatalExceptionClasses != null) {
            fb.setFatalExceptionClasses(this.fatalExceptionClasses);
        }
        if (this.noRollbackExceptionClasses != null) {
            fb.setNoRollbackExceptionClasses(this.noRollbackExceptionClasses);
        }
    }

    private void configureTaskletStep(TaskletStep ts) {
        if (this.name != null) {
            ts.setName(this.name);
        }
        if (this.allowStartIfComplete != null) {
            ts.setAllowStartIfComplete(this.allowStartIfComplete);
        }
        if (this.jobRepository != null) {
            ts.setJobRepository(this.jobRepository);
        }
        if (this.startLimit != null) {
            ts.setStartLimit(this.startLimit);
        }
        if (this.tasklet != null) {
            ts.setTasklet(this.tasklet);
        }
        if (this.transactionManager != null) {
            ts.setTransactionManager(this.transactionManager);
        }
        if (this.listeners != null) {
            int i = 0;
            StepExecutionListener[] newListeners = new StepExecutionListener[this.listeners.length];
            StepListener[] stepListenerArray = this.listeners;
            int n = this.listeners.length;
            int n2 = 0;
            while (n2 < n) {
                StepListener listener = stepListenerArray[n2];
                newListeners[i++] = (StepExecutionListener)listener;
                ++n2;
            }
            ts.setStepExecutionListeners(newListeners);
        }
        if (this.transactionTimeout != null || this.propagation != null || this.isolation != null || this.noRollbackExceptionClasses != null) {
            DefaultTransactionAttribute attribute = new DefaultTransactionAttribute();
            if (this.propagation != null) {
                attribute.setPropagationBehavior(this.propagation.value());
            }
            if (this.isolation != null) {
                attribute.setIsolationLevel(this.isolation.value());
            }
            if (this.transactionTimeout != null) {
                attribute.setTimeout(this.transactionTimeout.intValue());
            }
            Collection<Object> exceptions = this.noRollbackExceptionClasses == null ? new HashSet() : this.noRollbackExceptionClasses;
            final BinaryExceptionClassifier classifier = new BinaryExceptionClassifier(exceptions, false);
            ts.setTransactionAttribute((TransactionAttribute)new DefaultTransactionAttribute((TransactionAttribute)attribute){

                public boolean rollbackOn(Throwable ex) {
                    return (Boolean)classifier.classify((Object)ex);
                }
            });
        }
    }

    private void validateFaultTolerantSettings() {
        this.validateDependency("skippable-exception-classes", this.skippableExceptionClasses, "skip-limit", this.skipLimit, true);
        this.validateDependency("fatal-exception-classes", this.fatalExceptionClasses, "skip-limit", this.skipLimit, false);
        this.validateDependency("retryable-exception-classes", this.retryableExceptionClasses, "retry-limit", this.retryLimit, true);
        this.validateDependency("retry-listeners", this.retryListeners, "retry-limit", this.retryLimit, false);
    }

    private void validateDependency(String dependantName, Object dependantValue, String name, Object value, boolean twoWayDependency) {
        if (this.isPresent(dependantValue) && !this.isPresent(value)) {
            throw new IllegalArgumentException("The field '" + dependantName + "' is not permitted on the step [" + this.name + "] because there is no '" + name + "'.");
        }
        if (twoWayDependency && this.isPresent(value) && !this.isPresent(dependantValue)) {
            throw new IllegalArgumentException("The field '" + name + "' is not permitted on the step [" + this.name + "] because there is no '" + dependantName + "'.");
        }
    }

    private boolean isPresent(Object o) {
        if (o instanceof Integer) {
            return this.isPositive((Integer)o);
        }
        return o != null;
    }

    private boolean isFaultTolerant() {
        return this.isPositive(this.skipLimit) || this.isPositive(this.retryLimit) || this.isPositive(this.cacheCapacity) || this.isTrue(this.isReaderTransactionalQueue);
    }

    private boolean isTrue(Boolean b) {
        return b != null && b != false;
    }

    private boolean isPositive(Integer n) {
        return n != null && n > 0;
    }

    public Class<TaskletStep> getObjectType() {
        return TaskletStep.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanName(String name) {
        if (this.name == null) {
            this.name = name;
        }
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setStartLimit(int startLimit) {
        this.startLimit = startLimit;
    }

    public void setTasklet(Tasklet tasklet) {
        this.tasklet = tasklet;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setListeners(StepListener[] listeners) {
        this.listeners = listeners;
    }

    public void setNoRollbackExceptionClasses(Collection<Class<? extends Throwable>> noRollbackExceptionClasses) {
        this.noRollbackExceptionClasses = noRollbackExceptionClasses;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public void setIsolation(Isolation isolation) {
        this.isolation = isolation;
    }

    public void setPropagation(Propagation propagation) {
        this.propagation = propagation;
    }

    public void setCacheCapacity(int cacheCapacity) {
        this.cacheCapacity = cacheCapacity;
    }

    public void setChunkCompletionPolicy(CompletionPolicy chunkCompletionPolicy) {
        this.chunkCompletionPolicy = chunkCompletionPolicy;
    }

    public void setCommitInterval(int commitInterval) {
        this.commitInterval = commitInterval;
    }

    public void setIsReaderTransactionalQueue(boolean isReaderTransactionalQueue) {
        this.isReaderTransactionalQueue = isReaderTransactionalQueue;
    }

    public void setRetryLimit(int retryLimit) {
        this.retryLimit = retryLimit;
    }

    public void setSkipLimit(int skipLimit) {
        this.skipLimit = skipLimit;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setThrottleLimit(Integer throttleLimit) {
        this.throttleLimit = throttleLimit;
    }

    public void setItemReader(ItemReader<? extends I> itemReader) {
        this.itemReader = itemReader;
    }

    public void setItemProcessor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemWriter(ItemWriter<? super O> itemWriter) {
        this.itemWriter = itemWriter;
    }

    public void setRetryListeners(RetryListener ... retryListeners) {
        this.retryListeners = retryListeners;
    }

    public void setSkippableExceptionClasses(Collection<Class<? extends Throwable>> exceptionClasses) {
        this.skippableExceptionClasses = exceptionClasses;
    }

    public void setRetryableExceptionClasses(Collection<Class<? extends Throwable>> retryableExceptionClasses) {
        this.retryableExceptionClasses = retryableExceptionClasses;
    }

    public void setFatalExceptionClasses(Collection<Class<? extends Throwable>> fatalExceptionClasses) {
        this.fatalExceptionClasses = fatalExceptionClasses;
    }

    public void setStreams(ItemStream[] streams) {
        this.streams = streams;
    }

    public void setHasChunkElement(boolean hasChunkElement) {
        this.hasChunkElement = hasChunkElement;
    }
}

