/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OrderedComposite<S> {
    private List<S> unordered = new ArrayList<S>();
    private Collection<S> ordered = new TreeSet<S>(new AnnotationAwareOrderComparator());
    private List<S> list = new ArrayList<S>();

    OrderedComposite() {
    }

    public void setItems(List<? extends S> items) {
        this.unordered.clear();
        this.ordered.clear();
        for (S s : items) {
            this.add(s);
        }
    }

    public void add(S item) {
        if (item instanceof Ordered) {
            if (!this.ordered.contains(item)) {
                this.ordered.add(item);
            }
        } else if (!this.unordered.contains(item)) {
            this.unordered.add(item);
        }
        this.list.clear();
        this.list.addAll(this.ordered);
        this.list.addAll(this.unordered);
    }

    public Iterator<S> iterator() {
        return new ArrayList<S>(this.list).iterator();
    }

    public Iterator<S> reverse() {
        ArrayList<S> result = new ArrayList<S>(this.list);
        Collections.reverse(result);
        return result.iterator();
    }
}

