/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope.context;

import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.batch.core.JobInterruptedException;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;

@Aspect
public class StepScopeManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(void org.springframework.batch.core.Step+.execute(*)) && target(step) && args(stepExecution)")
    public void execute(Step step, StepExecution stepExecution) throws JobInterruptedException {
        StepSynchronizationManager.register(stepExecution);
        try {
            step.execute(stepExecution);
        }
        finally {
            StepSynchronizationManager.release();
        }
    }
}

