/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.SerializationUtils;

public class MapJobExecutionDao
implements JobExecutionDao {
    private final ConcurrentMap<Long, JobExecution> executionsById = new ConcurrentHashMap<Long, JobExecution>();
    private final AtomicLong currentId = new AtomicLong(0L);

    public void clear() {
        this.executionsById.clear();
    }

    private static JobExecution copy(JobExecution original) {
        JobExecution copy = (JobExecution)SerializationUtils.deserialize((byte[])SerializationUtils.serialize((Object)original));
        return copy;
    }

    @Override
    public void saveJobExecution(JobExecution jobExecution) {
        Assert.isTrue((jobExecution.getId() == null ? 1 : 0) != 0, (String)"jobExecution id is not null");
        Long newId = this.currentId.getAndIncrement();
        jobExecution.setId(newId);
        jobExecution.incrementVersion();
        this.executionsById.put(newId, MapJobExecutionDao.copy(jobExecution));
    }

    @Override
    public List<JobExecution> findJobExecutions(JobInstance jobInstance) {
        ArrayList<JobExecution> executions = new ArrayList<JobExecution>();
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            executions.add(MapJobExecutionDao.copy(exec));
        }
        Collections.sort(executions, new Comparator<JobExecution>(){

            @Override
            public int compare(JobExecution e1, JobExecution e2) {
                long result = e1.getId() - e2.getId();
                if (result > 0L) {
                    return -1;
                }
                if (result < 0L) {
                    return 1;
                }
                return 0;
            }
        });
        return executions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateJobExecution(JobExecution jobExecution) {
        Long id = jobExecution.getId();
        Assert.notNull((Object)id, (String)"JobExecution is expected to have an id (should be saved already)");
        JobExecution persistedExecution = (JobExecution)this.executionsById.get(id);
        Assert.notNull((Object)persistedExecution, (String)"JobExecution must already be saved");
        JobExecution jobExecution2 = jobExecution;
        synchronized (jobExecution2) {
            if (!persistedExecution.getVersion().equals(jobExecution.getVersion())) {
                throw new OptimisticLockingFailureException("Attempt to update job execution id=" + id + " with wrong version (" + jobExecution.getVersion() + "), where current version is " + persistedExecution.getVersion());
            }
            jobExecution.incrementVersion();
            this.executionsById.put(id, MapJobExecutionDao.copy(jobExecution));
        }
    }

    @Override
    public JobExecution getLastJobExecution(@Nullable JobInstance jobInstance) {
        JobExecution lastExec = null;
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().equals(jobInstance)) continue;
            if (lastExec == null) {
                lastExec = exec;
            }
            if (!lastExec.getCreateTime().before(exec.getCreateTime())) continue;
            lastExec = exec;
        }
        return MapJobExecutionDao.copy(lastExec);
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        HashSet<JobExecution> result = new HashSet<JobExecution>();
        for (JobExecution exec : this.executionsById.values()) {
            if (!exec.getJobInstance().getJobName().equals(jobName) || !exec.isRunning()) continue;
            result.add(MapJobExecutionDao.copy(exec));
        }
        return result;
    }

    @Override
    @Nullable
    public JobExecution getJobExecution(Long executionId) {
        return MapJobExecutionDao.copy((JobExecution)this.executionsById.get(executionId));
    }

    @Override
    public void synchronizeStatus(JobExecution jobExecution) {
        JobExecution saved = this.getJobExecution(jobExecution.getId());
        if (saved.getVersion().intValue() != jobExecution.getVersion().intValue()) {
            jobExecution.upgradeStatus(saved.getStatus());
            jobExecution.setVersion(saved.getVersion());
        }
    }
}

