/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.explore.support;

import java.util.List;
import java.util.Set;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.lang.Nullable;

public class SimpleJobExplorer
implements JobExplorer {
    private JobInstanceDao jobInstanceDao;
    private JobExecutionDao jobExecutionDao;
    private StepExecutionDao stepExecutionDao;
    private ExecutionContextDao ecDao;

    SimpleJobExplorer() {
    }

    public SimpleJobExplorer(JobInstanceDao jobInstanceDao, JobExecutionDao jobExecutionDao, StepExecutionDao stepExecutionDao, ExecutionContextDao ecDao) {
        this.jobInstanceDao = jobInstanceDao;
        this.jobExecutionDao = jobExecutionDao;
        this.stepExecutionDao = stepExecutionDao;
        this.ecDao = ecDao;
    }

    @Override
    public List<JobExecution> getJobExecutions(JobInstance jobInstance) {
        List<JobExecution> executions = this.jobExecutionDao.findJobExecutions(jobInstance);
        for (JobExecution jobExecution : executions) {
            this.getJobExecutionDependencies(jobExecution);
            for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                this.getStepExecutionDependencies(stepExecution);
            }
        }
        return executions;
    }

    @Override
    public Set<JobExecution> findRunningJobExecutions(String jobName) {
        Set<JobExecution> executions = this.jobExecutionDao.findRunningJobExecutions(jobName);
        for (JobExecution jobExecution : executions) {
            this.getJobExecutionDependencies(jobExecution);
            for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
                this.getStepExecutionDependencies(stepExecution);
            }
        }
        return executions;
    }

    @Override
    public JobExecution getJobExecution(Long executionId) {
        if (executionId == null) {
            return null;
        }
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(executionId);
        if (jobExecution == null) {
            return null;
        }
        this.getJobExecutionDependencies(jobExecution);
        for (StepExecution stepExecution : jobExecution.getStepExecutions()) {
            this.getStepExecutionDependencies(stepExecution);
        }
        return jobExecution;
    }

    @Override
    public StepExecution getStepExecution(Long jobExecutionId, Long executionId) {
        JobExecution jobExecution = this.jobExecutionDao.getJobExecution(jobExecutionId);
        if (jobExecution == null) {
            return null;
        }
        this.getJobExecutionDependencies(jobExecution);
        StepExecution stepExecution = this.stepExecutionDao.getStepExecution(jobExecution, executionId);
        this.getStepExecutionDependencies(stepExecution);
        return stepExecution;
    }

    @Override
    public JobInstance getJobInstance(@Nullable Long instanceId) {
        return this.jobInstanceDao.getJobInstance(instanceId);
    }

    @Override
    public List<JobInstance> getJobInstances(String jobName, int start, int count) {
        return this.jobInstanceDao.getJobInstances(jobName, start, count);
    }

    @Override
    public List<String> getJobNames() {
        return this.jobInstanceDao.getJobNames();
    }

    @Override
    public int getJobInstanceCount(@Nullable String jobName) throws NoSuchJobException {
        return this.jobInstanceDao.getJobInstanceCount(jobName);
    }

    private void getJobExecutionDependencies(JobExecution jobExecution) {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobExecution);
        this.stepExecutionDao.addStepExecutions(jobExecution);
        jobExecution.setJobInstance(jobInstance);
        jobExecution.setExecutionContext(this.ecDao.getExecutionContext(jobExecution));
    }

    private void getStepExecutionDependencies(StepExecution stepExecution) {
        if (stepExecution != null) {
            stepExecution.setExecutionContext(this.ecDao.getExecutionContext(stepExecution));
        }
    }

    @Override
    public List<JobInstance> findJobInstancesByJobName(String jobName, int start, int count) {
        return this.jobInstanceDao.findJobInstancesByName(jobName, start, count);
    }
}

